/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.osgi;

import java.util.Dictionary;
import java.util.Properties;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.scribble.common.logging.ConsoleJournal;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.export.DefaultProtocolExportManager;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.export.text.TextProtocolExporter;
import org.scribble.protocol.parser.DefaultProtocolParserManager;
import org.scribble.protocol.parser.ProtocolParser;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.validation.DefaultProtocolValidationManager;
import org.scribble.protocol.validation.ProtocolValidationManager;
import org.scribble.protocol.validation.ProtocolValidator;
import org.scribble.protocol.validation.rules.DefaultProtocolComponentValidator;

public class Activator
implements BundleActivator {
    private static final Logger _log = Logger.getLogger(Activator.class.getName());
    private ServiceTracker m_protocolParserTracker = null;
    private ServiceTracker m_protocolValidatorTracker = null;
    private ServiceTracker m_protocolExporterTracker = null;

    public void start(BundleContext context) throws Exception {
        Properties props = new Properties();
        final DefaultProtocolParserManager pm = new DefaultProtocolParserManager();
        context.registerService(ProtocolParserManager.class.getName(), (Object)pm, (Dictionary)props);
        _log.fine("Registered Parser Manager");
        this.m_protocolParserTracker = new ServiceTracker(context, ProtocolParser.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Object ret = super.addingService(ref);
                _log.fine("Parser has been added: " + ret);
                pm.addParser((ProtocolParser)ret);
                return ret;
            }
        };
        this.m_protocolParserTracker.open();
        final DefaultProtocolValidationManager vm = new DefaultProtocolValidationManager();
        context.registerService(ProtocolValidationManager.class.getName(), (Object)vm, (Dictionary)props);
        _log.fine("Registered Validation Manager");
        this.m_protocolValidatorTracker = new ServiceTracker(context, ProtocolValidator.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Object ret = super.addingService(ref);
                _log.fine("Validator has been added: " + ret);
                vm.addValidator((ProtocolValidator)ret);
                return ret;
            }
        };
        this.m_protocolValidatorTracker.open();
        final DefaultProtocolExportManager em = new DefaultProtocolExportManager();
        context.registerService(ProtocolExportManager.class.getName(), (Object)em, (Dictionary)props);
        _log.fine("Registered Export Manager");
        this.m_protocolExporterTracker = new ServiceTracker(context, ProtocolExporter.class.getName(), null){

            public Object addingService(ServiceReference ref) {
                Object ret = super.addingService(ref);
                _log.fine("Exporter has been added: " + ret);
                em.addExporter((ProtocolExporter)ret);
                return ret;
            }
        };
        this.m_protocolExporterTracker.open();
        context.registerService(Journal.class.getName(), (Object)new ConsoleJournal(), (Dictionary)props);
        props = new Properties();
        context.registerService(ProtocolValidator.class.getName(), (Object)new DefaultProtocolComponentValidator(), (Dictionary)props);
        props = new Properties();
        context.registerService(ProtocolExporter.class.getName(), (Object)new TextProtocolExporter(), (Dictionary)props);
    }

    public void stop(BundleContext context) throws Exception {
    }
}

