/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParser;
import org.scribble.protocol.parser.ProtocolParserManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProtocolParserManager
implements ProtocolParserManager {
    private List<ProtocolParser> m_parsers = new Vector<ProtocolParser>();
    private static final Logger logger = Logger.getLogger(DefaultProtocolParserManager.class.getName());

    @Override
    public void addParser(ProtocolParser parser) {
        this.m_parsers.add(parser);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Protocol parser '" + parser + "' registered with parser manager");
        }
    }

    @Override
    public void removeParser(ProtocolParser parser) {
        this.m_parsers.remove(parser);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Protocol parser '" + parser + "' unregistered from parser manager");
        }
    }

    @Override
    public ProtocolModel parse(String sourceType, InputStream is, Journal journal, ProtocolContext context) throws IOException {
        ProtocolModel ret = null;
        for (ProtocolParser p : this.m_parsers) {
            if (p.isSupported(sourceType) && (ret = p.parse(is, journal, context)) != null) break;
        }
        return ret;
    }

    @Override
    public List<ProtocolParser> getParsers() {
        return this.m_parsers;
    }
}

