/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.util;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceUtil {
    private static final String LABEL_SEPARATOR = "_";

    public static List<String> getLabels(ProtocolModel model) {
        final Vector<String> ret = new Vector<String>();
        model.visit(new DefaultVisitor(){

            public boolean start(When elem) {
                String label = ChoiceUtil.getLabel(elem.getMessageSignature());
                if (!ret.contains(label)) {
                    ret.add(label);
                }
                return true;
            }
        });
        return ret;
    }

    public static String getLabel(MessageSignature sig) {
        StringBuffer ret = new StringBuffer();
        if (sig.getOperation() != null) {
            ret.append(sig.getOperation());
        }
        for (TypeReference tref : sig.getTypeReferences()) {
            ret.append(LABEL_SEPARATOR);
            ret.append(tref.getName());
        }
        return ret.toString();
    }
}

