/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.export.text;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.export.text.TextProtocolExporterVisitor;
import org.scribble.protocol.model.ProtocolModel;

public class TextProtocolExporter
implements ProtocolExporter {
    public static final String TEXT_ID = "txt";

    public String getId() {
        return TEXT_ID;
    }

    public String getName() {
        return "Text";
    }

    public void export(ProtocolModel model, Journal journal, OutputStream os) {
        TextProtocolExporterVisitor visitor = this.createVisitor(journal, os);
        model.visit(visitor);
        if (visitor.getException() != null) {
            journal.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_EXPORT_FAILED"), visitor.getException().getLocalizedMessage()), null);
        }
    }

    protected TextProtocolExporterVisitor createVisitor(Journal journal, OutputStream os) {
        return new TextProtocolExporterVisitor(journal, os);
    }
}

