/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.OnMessage;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedChoice
extends Activity {
    private Role m_fromRole = null;
    private List<Role> m_toRoles = new ContainmentList<Role>(this, Role.class);
    private List<OnMessage> m_onMessages = new ContainmentList<OnMessage>(this, OnMessage.class);

    public Role getFromRole() {
        return this.m_fromRole;
    }

    public void setFromRole(Role part) {
        this.m_fromRole = part;
    }

    public List<Role> getToRoles() {
        return this.m_toRoles;
    }

    public List<OnMessage> getOnMessages() {
        return this.m_onMessages;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.start(this);
        if (this.getFromRole() != null) {
            this.getFromRole().visit(visitor);
        }
        for (Role toRole : this.getToRoles()) {
            toRole.visit(visitor);
        }
        for (OnMessage om : this.getOnMessages()) {
            om.visit(visitor);
        }
        visitor.end(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectedChoice that = (DirectedChoice)o;
        return !(this.m_fromRole == null ? that.m_fromRole != null : !this.m_fromRole.equals(that.m_fromRole)) && ((Object)this.m_onMessages).equals(that.m_onMessages);
    }

    public int hashCode() {
        int result = ((Object)this.m_onMessages).hashCode();
        result = 31 * result + (this.m_fromRole != null ? this.m_fromRole.hashCode() : 0);
        return result;
    }

    public String toString() {
        String result = "";
        if (this.m_fromRole != null) {
            result = result + "from " + this.m_fromRole + " ";
        }
        if (this.m_toRoles.size() > 0) {
            result = result + "to ";
            for (int i = 0; i < this.m_toRoles.size(); ++i) {
                if (i > 0) {
                    result = result + ", ";
                }
                result = result + this.m_toRoles.get(i);
            }
        }
        for (OnMessage b : this.m_onMessages) {
            if (this.m_onMessages.indexOf(b) > 0) {
                result = result + "or ";
            }
            result = result + b + "\n";
        }
        return result;
    }
}

