/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation;

import java.util.ArrayList;
import java.util.List;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.AbstractModelObjectVisitor;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;
import org.scribble.protocol.validation.ProtocolValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolComponentValidator
implements ProtocolValidator {
    private List<ProtocolComponentValidatorRule> m_rules = null;

    public List<ProtocolComponentValidatorRule> getRules() {
        if (this.m_rules == null) {
            this.m_rules = new ArrayList<ProtocolComponentValidatorRule>();
        }
        return this.m_rules;
    }

    public void setRules(List<ProtocolComponentValidatorRule> rules) {
        this.m_rules = rules;
    }

    @Override
    public void validate(ProtocolModel model, Journal logger) {
        model.visit(new ValidatingVisitor(logger));
    }

    public class ValidatingVisitor
    extends AbstractModelObjectVisitor {
        private Journal m_logger = null;

        public ValidatingVisitor(Journal logger) {
            this.m_logger = logger;
        }

        public boolean process(ModelObject obj) {
            for (ProtocolComponentValidatorRule rule : ProtocolComponentValidator.this.getRules()) {
                if (!rule.isSupported(obj)) continue;
                rule.validate(obj, this.m_logger);
            }
            return true;
        }
    }
}

