/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.RoleUtil;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;

public class ChoiceValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Choice.class;
    }

    public void validate(ModelObject obj, Journal logger) {
        Set<Role> roles;
        Choice elem = (Choice)obj;
        Role locatedRole = null;
        if (elem.enclosingProtocol() != null) {
            locatedRole = elem.enclosingProtocol().getRole();
        }
        if (elem.getRole() != null && !(roles = RoleUtil.getRolesInScope(elem)).contains(elem.getRole())) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), elem.getRole().getName()), obj.getProperties());
        }
        if (locatedRole != null && elem.getRole() != null && !elem.getRole().equals(locatedRole)) {
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNRELATED_TO_LOCATED_ROLE"), locatedRole.getName()), obj.getProperties());
        }
    }
}

