/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.validation.rules;

import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.Set;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Repeat;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.util.RoleUtil;
import org.scribble.protocol.validation.ProtocolComponentValidatorRule;

public class RepeatValidatorRule
implements ProtocolComponentValidatorRule {
    public boolean isSupported(ModelObject obj) {
        return obj.getClass() == Repeat.class;
    }

    public void validate(ModelObject obj, Journal logger) {
        Repeat elem = (Repeat)obj;
        Set<Role> roles = RoleUtil.getRolesInScope(elem);
        for (Role role : elem.getRoles()) {
            if (roles.contains(role)) continue;
            logger.error(MessageFormat.format(PropertyResourceBundle.getBundle("org.scribble.protocol.Messages").getString("_UNKNOWN_ROLE"), role.getName()), obj.getProperties());
        }
    }
}

