/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.protocol.model;

import java.util.List;
import java.util.Vector;
import org.scribble.protocol.model.ContainmentList;
import org.scribble.protocol.model.DefaultVisitor;
import org.scribble.protocol.model.ImportList;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.Protocol;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolModel
extends ModelObject {
    private Protocol _definition = null;
    private List<ImportList> _imports = new ContainmentList<ImportList>(this, ImportList.class);

    public List<ImportList> getImports() {
        return this._imports;
    }

    public Protocol getProtocol() {
        return this._definition;
    }

    public void setProtocol(Protocol defn) {
        if (this._definition != null) {
            this._definition.setParent(null);
        }
        this._definition = defn;
        if (this._definition != null) {
            this._definition.setParent(this);
        }
    }

    public boolean isLocated() {
        boolean ret = false;
        if (this.getProtocol() != null) {
            ret = this.getProtocol().getLocatedRole() != null;
        }
        return ret;
    }

    public List<Role> getRoles() {
        final Vector<Role> ret = new Vector<Role>();
        this.visit(new DefaultVisitor(){

            public boolean start(Protocol elem) {
                for (Role r : elem.getRoles()) {
                    if (ret.contains(r)) continue;
                    ret.add(r);
                }
                return true;
            }
        });
        return ret;
    }

    @Override
    public void visit(Visitor visitor) {
        for (ImportList imp : this.getImports()) {
            imp.visit(visitor);
        }
        if (this.getProtocol() != null) {
            this.getProtocol().visit(visitor);
        }
    }
}

