/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.commandline;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoProcessor;
import org.apache.felix.main.Main;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.scribble.command.Command;
import org.scribble.commandline.osgi.HostActivator;

public class ScribbleCL {
    private HostActivator m_activator = null;
    private Felix m_felix = null;
    private ServiceTracker m_tracker = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Command must be specified as first parameter");
            System.exit(1);
        }
        try {
            ScribbleCL scl = new ScribbleCL();
            String[] parameters = new String[args.length - 1];
            for (int i = 1; i < args.length; ++i) {
                parameters[i - 1] = args[i];
            }
            if (!scl.execute(args[0], parameters)) {
                System.err.println("Command not executed");
            }
            scl.shutdownApplication();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ScribbleCL() {
        Main.loadSystemProperties();
        Properties configProps = Main.loadConfigProperties();
        if (configProps == null) {
            System.err.println("No config.properties found.");
            configProps = new Properties();
        }
        Main.copySystemProperties((Properties)configProps);
        configProps.put("org.osgi.framework.system.packages.extra", "org.scribble.command");
        this.m_activator = new HostActivator();
        ArrayList<HostActivator> list = new ArrayList<HostActivator>();
        list.add(this.m_activator);
        configProps.put("felix.systembundle.activators", list);
        try {
            this.m_felix = new Felix((Map)configProps);
            this.m_felix.init();
            AutoProcessor.process((Map)configProps, (BundleContext)this.m_felix.getBundleContext());
            this.m_felix.start();
        }
        catch (Exception ex) {
            System.err.println("Could not create framework: " + ex);
            ex.printStackTrace();
        }
        this.m_tracker = new ServiceTracker(this.m_activator.getContext(), Command.class.getName(), null);
        this.m_tracker.open();
    }

    public boolean execute(String name, String[] args) {
        Object[] services = this.m_tracker.getServices();
        for (int i = 0; services != null && i < services.length; ++i) {
            try {
                if (!((Command)services[i]).getName().equals(name)) continue;
                return ((Command)services[i]).execute(args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public void shutdownApplication() throws Exception {
        this.m_felix.stop();
        this.m_felix.waitForStop(5000L);
    }
}

