/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.conforms;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolContext;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.conformance.ProtocolConformer;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;

public class ConformsCommand
implements Command {
    private Journal m_journal = null;
    private ProtocolParserManager m_protocolParserManager = null;
    private ProtocolConformer m_conformer = null;

    public void setJournal(Journal journal) {
        this.m_journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this.m_protocolParserManager = parser;
    }

    public void setConformer(ProtocolConformer conformer) {
        this.m_conformer = conformer;
    }

    public String getName() {
        return "conforms";
    }

    public String getDescription() {
        return "Check two Scribble descriptions for conformance";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 2) {
            File f1 = new File(args[0]);
            File f2 = new File(args[1]);
            if (!f1.exists()) {
                this.m_journal.error("File not found '" + args[0] + "'", null);
            } else if (!f2.exists()) {
                this.m_journal.error("File not found '" + args[1] + "'", null);
            } else {
                try {
                    FileInputStream is = new FileInputStream(f1);
                    int index = f1.getName().lastIndexOf(46);
                    String sourceType = null;
                    if (index != -1) {
                        sourceType = f1.getName().substring(index + 1);
                    }
                    ProtocolModel p1 = this.m_protocolParserManager.parse(sourceType, (InputStream)is, this.m_journal, (ProtocolContext)new DefaultProtocolContext(this.m_protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f1.getParentFile())));
                    ((InputStream)is).close();
                    is = new FileInputStream(f2);
                    index = f2.getName().lastIndexOf(46);
                    sourceType = null;
                    if (index != -1) {
                        sourceType = f2.getName().substring(index + 1);
                    }
                    ProtocolModel p2 = this.m_protocolParserManager.parse(sourceType, (InputStream)is, this.m_journal, (ProtocolContext)new DefaultProtocolContext(this.m_protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f2.getParentFile())));
                    ((InputStream)is).close();
                    if (p1 != null && p2 != null) {
                        this.m_conformer.conforms(p1, p2, this.m_journal);
                        ret = true;
                    }
                }
                catch (Exception e) {
                    this.m_journal.error("Failed to check conformance of '" + args[0] + "' against '" + args[1] + "': " + e, null);
                    e.printStackTrace();
                }
            }
        } else {
            this.m_journal.error("CONFORMS EXPECTING 2 PARAMETERS", null);
        }
        return ret;
    }
}

