/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.osgi;

import java.util.Dictionary;
import java.util.Properties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.scribble.command.Command;
import org.scribble.command.conforms.ConformsCommand;
import org.scribble.command.parse.ParseCommand;
import org.scribble.command.project.ProjectCommand;
import org.scribble.command.simulate.SimulateCommand;
import org.scribble.command.validate.ValidateCommand;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.conformance.ProtocolConformer;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.parser.ProtocolParserManager;
import org.scribble.protocol.projection.ProtocolProjector;
import org.scribble.protocol.validation.ProtocolValidationManager;

public class Activator
implements BundleActivator {
    public void start(final BundleContext context) {
        final Commands commands = new Commands();
        Properties props = new Properties();
        commands.setParseCommand(new ParseCommand());
        context.registerService(Command.class.getName(), (Object)commands.getParseCommand(), (Dictionary)props);
        commands.setValidateCommand(new ValidateCommand());
        context.registerService(Command.class.getName(), (Object)commands.getValidateCommand(), (Dictionary)props);
        commands.setConformsCommand(new ConformsCommand());
        context.registerService(Command.class.getName(), (Object)commands.getConformsCommand(), (Dictionary)props);
        commands.setProjectCommand(new ProjectCommand());
        context.registerService(Command.class.getName(), (Object)commands.getProjectCommand(), (Dictionary)props);
        commands.setSimulateCommand(new SimulateCommand());
        context.registerService(Command.class.getName(), (Object)commands.getSimulateCommand(), (Dictionary)props);
        ServiceListener sl1 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolValidationManager vm = (ProtocolValidationManager)context.getService(sr);
                        commands.setProtocolValidationManager(vm);
                        break;
                    }
                }
            }
        };
        ServiceListener sl2 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        Journal journal = (Journal)context.getService(sr);
                        commands.setJournal(journal);
                        break;
                    }
                }
            }
        };
        ServiceListener sl3 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolParserManager pp = (ProtocolParserManager)context.getService(sr);
                        commands.setProtocolParserManager(pp);
                        break;
                    }
                }
            }
        };
        ServiceListener sl4 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolConformer conformer = (ProtocolConformer)context.getService(sr);
                        commands.setProtocolConformer(conformer);
                        break;
                    }
                }
            }
        };
        ServiceListener sl5 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolProjector projector = (ProtocolProjector)context.getService(sr);
                        commands.setProtocolProjector(projector);
                        break;
                    }
                }
            }
        };
        ServiceListener sl6 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolExportManager em = (ProtocolExportManager)context.getService(sr);
                        commands.setProtocolExportManager(em);
                        break;
                    }
                }
            }
        };
        ServiceListener sl7 = new ServiceListener(){

            public void serviceChanged(ServiceEvent ev) {
                ServiceReference sr = ev.getServiceReference();
                switch (ev.getType()) {
                    case 1: {
                        ProtocolMonitor pm = (ProtocolMonitor)context.getService(sr);
                        commands.setProtocolMonitor(pm);
                        break;
                    }
                }
            }
        };
        String filter1 = "(objectclass=" + ProtocolValidationManager.class.getName() + ")";
        String filter2 = "(objectclass=" + Journal.class.getName() + ")";
        String filter3 = "(objectclass=" + ProtocolParserManager.class.getName() + ")";
        String filter4 = "(objectclass=" + ProtocolConformer.class.getName() + ")";
        String filter5 = "(objectclass=" + ProtocolProjector.class.getName() + ")";
        String filter6 = "(objectclass=" + ProtocolExportManager.class.getName() + ")";
        String filter7 = "(objectclass=" + ProtocolMonitor.class.getName() + ")";
        try {
            ServiceReference sref = context.getServiceReference(ProtocolValidationManager.class.getName());
            ProtocolValidationManager pvm = (ProtocolValidationManager)context.getService(sref);
            if (pvm != null) {
                commands.setProtocolValidationManager(pvm);
            } else {
                context.addServiceListener(sl1, filter1);
            }
            sref = context.getServiceReference(Journal.class.getName());
            Journal journal = (Journal)context.getService(sref);
            if (journal != null) {
                commands.setJournal(journal);
            } else {
                context.addServiceListener(sl2, filter2);
            }
            sref = context.getServiceReference(ProtocolParserManager.class.getName());
            ProtocolParserManager pp = null;
            if (sref != null) {
                pp = (ProtocolParserManager)context.getService(sref);
            }
            if (pp != null) {
                commands.setProtocolParserManager(pp);
            } else {
                context.addServiceListener(sl3, filter3);
            }
            sref = context.getServiceReference(ProtocolConformer.class.getName());
            ProtocolConformer pc = null;
            if (sref != null) {
                pc = (ProtocolConformer)context.getService(sref);
            }
            if (pc != null) {
                commands.setProtocolConformer(pc);
            } else {
                context.addServiceListener(sl4, filter4);
            }
            sref = context.getServiceReference(ProtocolProjector.class.getName());
            ProtocolProjector ppj = null;
            if (sref != null) {
                ppj = (ProtocolProjector)context.getService(sref);
            }
            if (ppj != null) {
                commands.setProtocolProjector(ppj);
            } else {
                context.addServiceListener(sl5, filter5);
            }
            sref = context.getServiceReference(ProtocolExportManager.class.getName());
            ProtocolExportManager pem = null;
            if (sref != null) {
                pem = (ProtocolExportManager)context.getService(sref);
            }
            if (pem != null) {
                commands.setProtocolExportManager(pem);
            } else {
                context.addServiceListener(sl6, filter6);
            }
            sref = context.getServiceReference(ProtocolMonitor.class.getName());
            ProtocolMonitor pm = null;
            if (sref != null) {
                pm = (ProtocolMonitor)context.getService(sref);
            }
            if (pm != null) {
                commands.setProtocolMonitor(pm);
            } else {
                context.addServiceListener(sl7, filter7);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) {
    }

    protected class Commands {
        private ParseCommand m_parseCommand = null;
        private ValidateCommand m_validateCommand = null;
        private ConformsCommand m_conformsCommand = null;
        private ProjectCommand m_projectCommand = null;
        private SimulateCommand m_simulateCommand = null;

        protected Commands() {
        }

        public void setProtocolValidationManager(ProtocolValidationManager vm) {
            this.m_validateCommand.setValidationManager(vm);
        }

        public void setJournal(Journal journal) {
            this.m_parseCommand.setJournal(journal);
            this.m_validateCommand.setJournal(journal);
            this.m_conformsCommand.setJournal(journal);
            this.m_projectCommand.setJournal(journal);
            this.m_simulateCommand.setJournal(journal);
        }

        public void setProtocolParserManager(ProtocolParserManager pp) {
            this.m_parseCommand.setProtocolParserManager(pp);
            this.m_validateCommand.setProtocolParserManager(pp);
            this.m_conformsCommand.setProtocolParserManager(pp);
            this.m_projectCommand.setProtocolParserManager(pp);
            this.m_simulateCommand.setProtocolParserManager(pp);
        }

        public void setProtocolConformer(ProtocolConformer pc) {
            this.m_conformsCommand.setConformer(pc);
        }

        public void setProtocolProjector(ProtocolProjector pp) {
            this.m_projectCommand.setProtocolProjector(pp);
        }

        public void setProtocolExportManager(ProtocolExportManager em) {
            this.m_projectCommand.setProtocolExportManager(em);
            this.m_simulateCommand.setProtocolExportManager(em);
        }

        public void setProtocolMonitor(ProtocolMonitor pm) {
            this.m_simulateCommand.setProtocolMonitor(pm);
        }

        public void setParseCommand(ParseCommand command) {
            this.m_parseCommand = command;
        }

        public ParseCommand getParseCommand() {
            return this.m_parseCommand;
        }

        public void setValidateCommand(ValidateCommand command) {
            this.m_validateCommand = command;
        }

        public ValidateCommand getValidateCommand() {
            return this.m_validateCommand;
        }

        public void setConformsCommand(ConformsCommand command) {
            this.m_conformsCommand = command;
        }

        public ConformsCommand getConformsCommand() {
            return this.m_conformsCommand;
        }

        public void setProjectCommand(ProjectCommand command) {
            this.m_projectCommand = command;
        }

        public ProjectCommand getProjectCommand() {
            return this.m_projectCommand;
        }

        public void setSimulateCommand(SimulateCommand command) {
            this.m_simulateCommand = command;
        }

        public SimulateCommand getSimulateCommand() {
            return this.m_simulateCommand;
        }
    }
}

