/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.scribble.command.Command;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.parser.ProtocolParserManager;

public class ParseCommand
implements Command {
    private Journal m_journal = null;
    private ProtocolParserManager m_protocolParserManager = null;

    public void setJournal(Journal journal) {
        this.m_journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this.m_protocolParserManager = parser;
    }

    public String getName() {
        return "parse";
    }

    public String getDescription() {
        return "Parse a Scribble description";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 1) {
            this.m_journal.info("PARSE " + args[0], null);
            File f = new File(args[0]);
            if (!f.exists()) {
                this.m_journal.error("File not found '" + args[0] + "'", null);
            } else {
                try {
                    ProtocolModel pm;
                    FileInputStream is = new FileInputStream(f);
                    int index = f.getName().lastIndexOf(46);
                    String sourceType = null;
                    if (index != -1) {
                        sourceType = f.getName().substring(index + 1);
                    }
                    if ((pm = this.m_protocolParserManager.parse(sourceType, (InputStream)is, this.m_journal, null)) == null) {
                        this.m_journal.error("Protocol Model is null", null);
                    }
                    ((InputStream)is).close();
                    ret = true;
                }
                catch (Exception e) {
                    this.m_journal.error("Failed to parse file '" + args[0] + "'", null);
                }
            }
        } else {
            this.m_journal.error("PARSE EXPECTING 1 PARAMETER", null);
        }
        return ret;
    }
}

