/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.simulate;

import java.io.InputStream;
import java.util.List;
import java.util.Vector;
import org.scribble.command.simulate.Event;
import org.scribble.command.simulate.ReceiveChoice;
import org.scribble.command.simulate.ReceiveDecision;
import org.scribble.command.simulate.ReceiveMessage;
import org.scribble.command.simulate.SendChoice;
import org.scribble.command.simulate.SendDecision;
import org.scribble.command.simulate.SendMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventProcessor {
    private List<Event> m_events = new Vector<Event>();

    public void initialize(InputStream events) throws Exception {
        byte[] b = new byte[events.available()];
        events.read(b);
        String buf = new String(b);
        String[] lines = buf.split("[\r\n]");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            if (line.length() <= 0) continue;
            String[] cols = line.split(",");
            Event evt = null;
            for (int j = 0; j < cols.length; ++j) {
                if (j == 0) {
                    if (cols[j].equals("sendMessage")) {
                        evt = new SendMessage();
                        continue;
                    }
                    if (cols[j].equals("receiveMessage")) {
                        evt = new ReceiveMessage();
                        continue;
                    }
                    if (cols[j].equals("sendDecision")) {
                        evt = new SendDecision();
                        continue;
                    }
                    if (cols[j].equals("receiveDecision")) {
                        evt = new ReceiveDecision();
                        continue;
                    }
                    if (cols[j].equals("sendChoice")) {
                        evt = new SendChoice();
                        continue;
                    }
                    if (cols[j].equals("receiveChoice")) {
                        evt = new ReceiveChoice();
                        continue;
                    }
                    System.err.println("Unknown event type '" + cols[j] + "'");
                    continue;
                }
                if (evt == null) continue;
                evt.setColumn(j, cols[j]);
            }
            if (evt == null) continue;
            this.m_events.add(evt);
        }
    }

    public List<Event> getEvents() {
        return this.m_events;
    }
}

