/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.command.simulate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.command.Command;
import org.scribble.command.simulate.Event;
import org.scribble.command.simulate.EventProcessor;
import org.scribble.common.logging.Journal;
import org.scribble.common.resource.DefaultResourceLocator;
import org.scribble.common.resource.ResourceLocator;
import org.scribble.protocol.DefaultProtocolContext;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.export.ProtocolExportManager;
import org.scribble.protocol.export.ProtocolExporter;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.monitor.DefaultMonitorContext;
import org.scribble.protocol.monitor.DefaultSession;
import org.scribble.protocol.monitor.MonitorContext;
import org.scribble.protocol.monitor.ProtocolMonitor;
import org.scribble.protocol.monitor.Session;
import org.scribble.protocol.monitor.model.Description;
import org.scribble.protocol.monitor.util.MonitorModelUtil;
import org.scribble.protocol.parser.ProtocolParserManager;

public class SimulateCommand
implements Command {
    private ProtocolMonitor m_protocolMonitor = null;
    private ProtocolExportManager m_protocolExportManager = null;
    private Journal m_journal = null;
    private ProtocolParserManager m_protocolParserManager = null;
    private static Logger _log = Logger.getLogger(SimulateCommand.class.getName());

    public void setProtocolMonitor(ProtocolMonitor pm) {
        this.m_protocolMonitor = pm;
    }

    public void setJournal(Journal journal) {
        this.m_journal = journal;
    }

    public void setProtocolParserManager(ProtocolParserManager parser) {
        this.m_protocolParserManager = parser;
    }

    public void setProtocolExportManager(ProtocolExportManager exportManager) {
        this.m_protocolExportManager = exportManager;
    }

    public String getName() {
        return "simulate";
    }

    public String getDescription() {
        return "Simulate a Scribble endpoint description against a list of events";
    }

    public boolean execute(String[] args) {
        boolean ret = false;
        if (args.length == 2) {
            this.m_journal.info("SIMULATE " + args[0] + " " + args[1], null);
            File f1 = new File(args[0]);
            File f2 = new File(args[1]);
            if (!f1.exists()) {
                this.m_journal.error("File not found '" + args[0] + "'", null);
            } else if (!f2.exists()) {
                this.m_journal.error("File not found '" + args[1] + "'", null);
            } else {
                try {
                    ProtocolModel model;
                    FileInputStream is = new FileInputStream(f1);
                    int index = f1.getName().lastIndexOf(46);
                    String sourceType = null;
                    if (index != -1) {
                        sourceType = f1.getName().substring(index + 1);
                    }
                    if ((model = this.m_protocolParserManager.parse(sourceType, (InputStream)is, this.m_journal, (ProtocolContext)new DefaultProtocolContext(this.m_protocolParserManager, (ResourceLocator)new DefaultResourceLocator(f1.getParentFile())))) != null) {
                        if (model.getProtocol().getRole() != null) {
                            this.simulate(model, f2);
                            ret = true;
                        } else {
                            this.m_journal.error("Protocol is not located at a role - only located protocols can be simulated", null);
                        }
                    } else {
                        this.m_journal.error("Protocol model not retrieved", null);
                    }
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    this.m_journal.error("Failed to parse file '" + args[0] + "'", null);
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("SIMULATE EXPECTING 2 PARAMETERS");
        }
        return ret;
    }

    public void simulate(ProtocolModel model, File eventFile) {
        ProtocolExporter exporter = this.m_protocolExportManager.getExporter("monitor");
        if (exporter != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                exporter.export(model, this.m_journal, (OutputStream)os);
                ByteArrayInputStream prtis = new ByteArrayInputStream(os.toByteArray());
                Description protocol = MonitorModelUtil.deserialize((InputStream)prtis);
                ((InputStream)prtis).close();
                if (_log.isLoggable(Level.FINE)) {
                    _log.fine("Protocol = " + protocol);
                }
                DefaultMonitorContext context = new DefaultMonitorContext();
                DefaultSession conv = new DefaultSession();
                this.m_protocolMonitor.initialize((MonitorContext)context, protocol, (Session)conv);
                FileInputStream is = new FileInputStream(eventFile);
                EventProcessor eventProcessor = new EventProcessor();
                eventProcessor.initialize(is);
                ((InputStream)is).close();
                for (Event event : eventProcessor.getEvents()) {
                    if (event.validate(this.m_protocolMonitor, (MonitorContext)context, protocol, (Session)conv).isValid()) {
                        this.m_journal.info("Validated " + event, null);
                        continue;
                    }
                    this.m_journal.error(event.toString(), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_journal.error("Failed to simulate process model: " + e, null);
            }
        } else {
            this.m_journal.error("Failed to export protocol model to monitoring representation", null);
        }
    }
}

