/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.SeleniumException;
import junit.framework.TestCase;

public class DefaultSeleniumStartErrorHandlingTest
extends TestCase {
    public void testWrapsConnectionRefusedWithUserFriendlyExceptionMessage() {
        FailOnStartCommandProcessor failOnStartCommandProcessor = new FailOnStartCommandProcessor("Connection refused: connect");
        try {
            new DefaultSelenium((CommandProcessor)failOnStartCommandProcessor).start();
            DefaultSeleniumStartErrorHandlingTest.fail((String)"Did not catch RuntimeException as expected");
        }
        catch (RuntimeException expected) {
            DefaultSeleniumStartErrorHandlingTest.assertTrue((-1 != expected.getMessage().indexOf("Could not contact Selenium Server; have you started it on '' ?") ? 1 : 0) != 0);
            DefaultSeleniumStartErrorHandlingTest.assertTrue((-1 != expected.getMessage().indexOf("Connection refused: connect") ? 1 : 0) != 0);
        }
    }

    public void testShouldLeaveOtherExceptionAlone() {
        FailOnStartCommandProcessor failOnStartCommandProcessor = new FailOnStartCommandProcessor("some crazy unexpected exception");
        try {
            new DefaultSelenium((CommandProcessor)failOnStartCommandProcessor).start();
            DefaultSeleniumStartErrorHandlingTest.fail((String)"Did not catch RuntimeException as expected");
        }
        catch (RuntimeException expected) {
            DefaultSeleniumStartErrorHandlingTest.assertTrue((-1 != expected.getMessage().indexOf("Could not start Selenium session: ") ? 1 : 0) != 0);
            DefaultSeleniumStartErrorHandlingTest.assertTrue((-1 != expected.getMessage().indexOf("some crazy unexpected exception") ? 1 : 0) != 0);
        }
    }

    private static class FailOnStartCommandProcessor
    implements CommandProcessor {
        private final String message;

        FailOnStartCommandProcessor(String message) {
            this.message = message;
        }

        public void setExtensionJs(String extensionJs) {
            throw new UnsupportedOperationException();
        }

        public void start() {
            throw new SeleniumException(this.message);
        }

        public void start(String optionsString) {
            throw new UnsupportedOperationException();
        }

        public void start(Object optionsObject) {
            throw new UnsupportedOperationException();
        }

        public String getRemoteControlServerLocation() {
            return "";
        }

        public String doCommand(String command, String[] args) {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean(String string, String[] strings) {
            throw new UnsupportedOperationException();
        }

        public boolean[] getBooleanArray(String string, String[] strings) {
            throw new UnsupportedOperationException();
        }

        public Number getNumber(String string, String[] strings) {
            throw new UnsupportedOperationException();
        }

        public Number[] getNumberArray(String string, String[] strings) {
            throw new UnsupportedOperationException();
        }

        public String getString(String string, String[] strings) {
            throw new UnsupportedOperationException();
        }

        public String[] getStringArray(String string, String[] strings) {
            throw new UnsupportedOperationException();
        }

        public void stop() {
            throw new UnsupportedOperationException();
        }
    }
}

