/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium;

import com.thoughtworks.selenium.HttpCommandProcessor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.easymock.classextension.ConstructorArgs;
import org.easymock.classextension.EasyMock;

public class HttpCommandProcessorUnitTest
extends TestCase {
    public void testCanStopTheSeleneseSessionEvenIfThereIsNoCurrentSession() {
        HttpCommandProcessor processor = new HttpCommandProcessor("a Server", 1234, "", "a url");
        processor.stop();
    }

    public void testCanStopTheSeleneseSessionWhenASessionIsInProgress() {
        HttpCommandProcessor processor = new HttpCommandProcessor("a Server", 1234, "", "a url"){

            public String doCommand(String commandName, String[] args) {
                Assert.assertEquals((String)"testComplete", (String)commandName);
                Assert.assertNull((Object)args);
                return null;
            }
        };
        processor.setSessionInProgress("123456789");
        processor.stop();
    }

    public void testResourcesClosedWhenIoeOnGetConnection() {
        IOEThrowingHttpCommandProcessor cmdProc = new IOEThrowingHttpCommandProcessor("localhost", 4444, "*chrome", "http://www.google.com");
        cmdProc.throwIoeOnGetConnection = true;
        try {
            String response = cmdProc.getCommandResponseAsString("testCommand");
            HttpCommandProcessorUnitTest.fail();
        }
        catch (IOException ioe) {
            cmdProc.verifyClosedResources(false, false, false);
        }
    }

    public void testResourcesClosedWhenIoeOnGetOutputStream() {
        IOEThrowingHttpCommandProcessor cmdProc = new IOEThrowingHttpCommandProcessor("localhost", 4444, "*chrome", "http://www.google.com");
        cmdProc.throwIoeOnGetOutputStream = true;
        try {
            String response = cmdProc.getCommandResponseAsString("testCommand");
            HttpCommandProcessorUnitTest.fail();
        }
        catch (IOException ioe) {
            cmdProc.verifyClosedResources(true, false, false);
        }
    }

    public void testResourcesClosedWhenIoeOnGetInputStream() {
        IOEThrowingHttpCommandProcessor cmdProc = new IOEThrowingHttpCommandProcessor("localhost", 4444, "*chrome", "http://www.google.com");
        cmdProc.throwIoeOnGetInputStream = true;
        try {
            String response = cmdProc.getCommandResponseAsString("testCommand");
            HttpCommandProcessorUnitTest.fail();
        }
        catch (IOException ioe) {
            cmdProc.verifyClosedResources(true, true, false);
        }
    }

    public void testResourcesClosedWhenNoIoes() {
        IOEThrowingHttpCommandProcessor cmdProc = new IOEThrowingHttpCommandProcessor("localhost", 4444, "*chrome", "http://www.google.com");
        try {
            String response = cmdProc.getCommandResponseAsString("testCommand");
            cmdProc.verifyClosedResources(true, true, true);
        }
        catch (IOException ioe) {
            HttpCommandProcessorUnitTest.fail();
        }
    }

    public void testGetBooleanArray() throws Exception {
        ConstructorArgs constArgs = new ConstructorArgs(HttpCommandProcessor.class.getConstructor(String.class, Integer.TYPE, String.class, String.class), new Object[]{"localhost", 4444, "*chrome", "http://www.openqa.org"});
        Method getStringArray = HttpCommandProcessor.class.getDeclaredMethod("getStringArray", String.class, String[].class);
        HttpCommandProcessor processor = (HttpCommandProcessor)EasyMock.createMock(HttpCommandProcessor.class, (ConstructorArgs)constArgs, (Method[])new Method[]{getStringArray});
        String[] cmdArgs = new String[]{"1", "2"};
        String[] cmdResults = new String[]{"true", "false"};
        boolean[] boolCmdResults = new boolean[]{true, false};
        EasyMock.expect((Object)processor.getStringArray("command", cmdArgs)).andReturn((Object)cmdResults);
        EasyMock.replay((Object[])new Object[]{processor});
        boolean[] methodResults = processor.getBooleanArray("command", cmdArgs);
        HttpCommandProcessorUnitTest.assertEquals((boolean)boolCmdResults[0], (boolean)methodResults[0]);
        HttpCommandProcessorUnitTest.assertEquals((boolean)boolCmdResults[1], (boolean)methodResults[1]);
        EasyMock.verify((Object[])new Object[]{processor});
    }

    private class IOEThrowingHttpCommandProcessor
    extends HttpCommandProcessor {
        private HttpURLConnection closedConn;
        private Writer closedWriter;
        private Reader closedReader;
        protected String responseString;
        protected boolean throwIoeOnGetConnection;
        protected boolean throwIoeOnGetInputStream;
        protected boolean throwIoeOnGetOutputStream;

        public IOEThrowingHttpCommandProcessor(String serverHost, int serverPort, String browserStartCommand, String browserURL) {
            super(serverHost, serverPort, browserStartCommand, browserURL);
            this.responseString = "normal response";
            this.throwIoeOnGetConnection = false;
            this.throwIoeOnGetInputStream = false;
            this.throwIoeOnGetOutputStream = false;
        }

        public IOEThrowingHttpCommandProcessor(String pathToServlet, String browserStartCommand, String browserURL) {
            super(pathToServlet, browserStartCommand, browserURL);
            this.responseString = "normal response";
            this.throwIoeOnGetConnection = false;
            this.throwIoeOnGetInputStream = false;
            this.throwIoeOnGetOutputStream = false;
        }

        protected HttpURLConnection getHttpUrlConnection(URL urlForServlet) throws IOException {
            if (this.throwIoeOnGetConnection) {
                throw new IOException("injected exception");
            }
            return super.getHttpUrlConnection(urlForServlet);
        }

        protected Writer getOutputStreamWriter(HttpURLConnection conn) throws IOException {
            if (this.throwIoeOnGetOutputStream) {
                throw new IOException("injected exception");
            }
            return new StringWriter(1024);
        }

        protected Reader getInputStreamReader(HttpURLConnection conn) throws IOException {
            if (this.throwIoeOnGetInputStream) {
                throw new IOException("injected exception");
            }
            return new StringReader(this.responseString);
        }

        protected int getResponseCode(HttpURLConnection conn) throws IOException {
            return 200;
        }

        protected void closeResources(HttpURLConnection conn, Writer wr, Reader rdr) {
            this.closedConn = conn;
            this.closedWriter = wr;
            this.closedReader = rdr;
            super.closeResources(conn, wr, rdr);
        }

        protected boolean verifyClosedResources(boolean connNotNull, boolean writerNotNull, boolean readerNotNull) {
            return connNotNull && null != this.closedConn && writerNotNull && null != this.closedWriter && readerNotNull && null != this.closedReader;
        }
    }
}

