/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.condition;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import com.thoughtworks.selenium.condition.Condition;
import com.thoughtworks.selenium.condition.ConditionRunner;
import com.thoughtworks.selenium.condition.JUnitConditionRunner;
import com.thoughtworks.selenium.condition.Not;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class ConditionTest
extends TestCase {
    private static final ConditionRunner conditionRunner = new JUnitConditionRunner(null, 1, 100);

    public void testAppendsInfoToFailureMessage() throws Exception {
        try {
            conditionRunner.waitFor("this condition should always fail", (Condition)new AlwaysFalseCondition());
            ConditionTest.fail((String)"the condition should have failed");
        }
        catch (AssertionFailedError expected) {
            ConditionTest.assertEquals((String)"Condition \"Sky should be blue\" failed to become true within 100 msec; this condition should always fail; [sky is in fact pink]", (String)expected.getMessage());
        }
    }

    public void testNotCanInvertFailingSituationQuickly() throws Exception {
        AlwaysFalseCondition alwaysFalse = new AlwaysFalseCondition();
        long start = System.currentTimeMillis();
        final StringBuilder sb = new StringBuilder();
        alwaysFalse.isTrue(new ConditionRunner.Context(){

            public ConditionRunner getConditionRunner() {
                return null;
            }

            public Selenium getSelenium() {
                return null;
            }

            public void info(String string) {
                sb.append(string);
            }

            public long elapsed() {
                return 0L;
            }
        });
        new JUnitConditionRunner(null, 0, 1000, 100000).waitFor((Condition)new Not((Condition)alwaysFalse));
        ConditionTest.assertTrue((System.currentTimeMillis() - start < 100L ? 1 : 0) != 0);
        ConditionTest.assertEquals((String)"sky is in fact pink", (String)sb.toString());
    }

    public void testNotCanNegatePassingSituationAfterTimeout() throws Exception {
        AlwaysTrueCondition alwaysTrue = new AlwaysTrueCondition();
        long start = System.currentTimeMillis();
        try {
            new JUnitConditionRunner(null, 0, 1000, 1000).waitFor((Condition)new Not((Condition)alwaysTrue));
            ConditionTest.fail((String)"the condition should have failed");
        }
        catch (AssertionFailedError expected) {
            long l = System.currentTimeMillis() - start;
            ConditionTest.assertTrue((l >= 1000L ? 1 : 0) != 0);
            ConditionTest.assertEquals((String)"Condition \"NOT of (Condition \"Sky should be blue\")\" failed to become true within 1000 msec; [yes it is really is blue]", (String)expected.getMessage());
        }
    }

    public void testCanTurnTrueBeforeTimeout() throws Exception {
        long start = System.currentTimeMillis();
        final int[] time = new int[1];
        JUnitConditionRunner conditionRunner1 = new JUnitConditionRunner(null, 0, 100, 2000);
        conditionRunner1.waitFor(new Condition(){

            public boolean isTrue(ConditionRunner.Context runner) {
                int n = time[0];
                time[0] = n + 1;
                return n >= 12;
            }
        });
        long l = System.currentTimeMillis() - start;
        ConditionTest.assertTrue((l >= 1200L ? 1 : 0) != 0);
        ConditionTest.assertTrue((l < 2000L ? 1 : 0) != 0);
    }

    public void testCannotTurnTrueAfterTimeout() throws Exception {
        long start = System.currentTimeMillis();
        final int[] time = new int[1];
        JUnitConditionRunner conditionRunner1 = new JUnitConditionRunner(null, 0, 100, 5000);
        try {
            conditionRunner1.waitFor(new Condition(){

                public boolean isTrue(ConditionRunner.Context runner) {
                    int n = time[0];
                    time[0] = n + 1;
                    return n == 52;
                }
            });
            ConditionTest.fail((String)"the condition should have failed");
        }
        catch (AssertionFailedError expected) {
            long l = System.currentTimeMillis() - start;
            ConditionTest.assertTrue((l >= 5000L ? 1 : 0) != 0);
        }
    }

    public void testCanLateNotifyOfSeleniumExceptionAfterTimeout() throws Exception {
        long start = System.currentTimeMillis();
        int[] time = new int[1];
        JUnitConditionRunner conditionRunner1 = new JUnitConditionRunner(null, 0, 100, 5000);
        try {
            conditionRunner1.waitFor(new Condition(){

                public boolean isTrue(ConditionRunner.Context runner) {
                    throw new SeleniumException("Yeehaa!");
                }
            });
            ConditionTest.fail((String)"the condition should have failed");
        }
        catch (AssertionFailedError expected) {
            ConditionTest.assertEquals((String)"SeleniumException while waiting for 'Condition \"null\"' (otherwise timed out); cause: Yeehaa!", (String)expected.getMessage());
            long l = System.currentTimeMillis() - start;
            ConditionTest.assertTrue((l >= 5000L ? 1 : 0) != 0);
        }
    }

    public void testRuntimeExceptionInsideConditionIsWrapped() {
        final RuntimeException thrownException = new RuntimeException("ooops");
        Condition condition = new Condition("foo"){

            public boolean isTrue(ConditionRunner.Context runner) {
                throw thrownException;
            }
        };
        try {
            conditionRunner.waitFor(condition);
            ConditionTest.fail((String)"should have thrown a exception");
        }
        catch (AssertionFailedError expected) {
            ConditionTest.assertEquals((String)"Exception while waiting for 'Condition \"foo\"'; cause: ooops", (String)expected.getMessage());
        }
    }

    public void testAssertionFailureInsideConditionIsNotWrapped() {
        Condition condition = new Condition(){

            public boolean isTrue(ConditionRunner.Context runner) {
                Assert.assertTrue((String)"OMG", (boolean)false);
                return false;
            }
        };
        try {
            conditionRunner.waitFor(condition);
            ConditionTest.fail((String)"should have thrown an assertion failed error");
        }
        catch (AssertionFailedError expected) {
            ConditionTest.assertEquals((String)"OMG", (String)expected.getMessage());
            ConditionTest.assertEquals(AssertionFailedError.class, ((Object)((Object)expected)).getClass());
        }
    }

    public void testMessageWithArgs() {
        final RuntimeException thrownException = new RuntimeException();
        Condition condition = new Condition("foo %s baz", "bar"){

            public boolean isTrue(ConditionRunner.Context runner) {
                throw thrownException;
            }
        };
        try {
            conditionRunner.waitFor(condition);
            ConditionTest.fail((String)"should have thrown a runtime exception");
        }
        catch (AssertionFailedError expected) {
            ConditionTest.assertEquals((String)"Exception while waiting for 'Condition \"foo bar baz\"'", (String)expected.getMessage());
        }
    }

    private static class AlwaysTrueCondition
    extends Condition {
        public AlwaysTrueCondition() {
            super("Sky should be blue");
        }

        public boolean isTrue(ConditionRunner.Context context) {
            context.info("yes it is really is blue");
            return true;
        }
    }

    private static class AlwaysFalseCondition
    extends Condition {
        public AlwaysFalseCondition() {
            super("Sky should be blue");
        }

        public boolean isTrue(ConditionRunner.Context context) {
            context.info("sky is in fact pink");
            return false;
        }
    }
}

