/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.htmlunit.ScriptException;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlOption;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.interactions.Coordinates;

public class HtmlUnitMouse {
    private final HtmlUnitDriver parent_;
    private final HtmlUnitKeyboard keyboard_;
    private DomElement currentActiveElement_;

    public HtmlUnitMouse(HtmlUnitDriver parent, HtmlUnitKeyboard keyboard) {
        this.parent_ = parent;
        this.keyboard_ = keyboard;
    }

    private DomElement getElementForOperation(Coordinates potentialCoordinates) {
        if (potentialCoordinates != null) {
            return (DomElement)potentialCoordinates.getAuxiliary();
        }
        if (this.currentActiveElement_ == null) {
            throw new NoSuchElementException("About to perform an interaction that relies on the active element, but there isn't one.");
        }
        return this.currentActiveElement_;
    }

    public void click(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.click(element, false);
    }

    void click(DomElement element, boolean directClick) {
        if (!element.isDisplayed()) {
            throw new ElementNotInteractableException("You may only interact with visible elements");
        }
        this.moveOutIfNeeded(element);
        try {
            element.mouseOver();
            element.mouseMove();
            element.click(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed() || directClick && element instanceof HtmlOption, this.keyboard_.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException) {
                throw new TimeoutException(cause);
            }
            throw e;
        }
    }

    private void moveOutIfNeeded(DomElement element) {
        try {
            if (this.currentActiveElement_ != element) {
                if (this.currentActiveElement_ != null) {
                    this.currentActiveElement_.mouseOver(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                    this.currentActiveElement_.mouseOut(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                }
                if (element != null) {
                    element.mouseMove(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                    element.mouseOver(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void updateActiveElement(DomElement element) {
        if (element != null) {
            this.currentActiveElement_ = element;
        }
    }

    public void doubleClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.doubleClick(element);
    }

    void doubleClick(DomElement element) {
        this.moveOutIfNeeded(element);
        try {
            element.dblClick(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void contextClick(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        element.rightClick(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed());
        this.updateActiveElement(element);
    }

    public void mouseDown(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.mouseDown(element);
    }

    void mouseDown(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseDown(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    public void mouseUp(Coordinates elementCoordinates) {
        DomElement element = this.getElementForOperation(elementCoordinates);
        this.parent_.mouseUp(element);
    }

    void mouseUp(DomElement element) {
        this.moveOutIfNeeded(element);
        element.mouseUp(this.keyboard_.isShiftPressed(), this.keyboard_.isCtrlPressed(), this.keyboard_.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    public void mouseMove(Coordinates elementCoordinates) {
        DomElement element = (DomElement)elementCoordinates.getAuxiliary();
        this.parent_.mouseMove(element);
    }

    void mouseMove(DomElement element) {
        this.moveOutIfNeeded(element);
        this.updateActiveElement(element);
    }

    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        throw new UnsupportedOperationException("Moving to arbitrary X,Y coordinates not supported.");
    }
}

