/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http.handler;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpContext;
import org.openqa.jetty.http.HttpException;
import org.openqa.jetty.http.HttpRequest;
import org.openqa.jetty.http.HttpResponse;
import org.openqa.jetty.http.handler.NotFoundHandler;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.ByteArrayISO8859Writer;
import org.openqa.jetty.util.StringUtil;

public class RootNotFoundHandler
extends NotFoundHandler {
    private static Log log = LogFactory.getLog(RootNotFoundHandler.class);

    @Override
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        log.debug((Object)"Root Not Found");
        String method = request.getMethod();
        if (!method.equals("GET") || !request.getPath().equals("/")) {
            super.handle(pathInContext, pathParams, request, response);
            return;
        }
        response.setStatus(404);
        request.setHandled(true);
        response.setReason("Not Found");
        response.setContentType("text/html");
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
        String uri = request.getPath();
        uri = StringUtil.replace(uri, "<", "&lt;");
        uri = StringUtil.replace(uri, ">", "&gt;");
        writer.write("<HTML>\n<HEAD>\n<TITLE>Error 404 - Not Found");
        writer.write("</TITLE>\n<BODY>\n<H2>Error 404 - Not Found.</H2>\n");
        writer.write("No context on this server matched or handled this request.<BR>");
        writer.write("Contexts known to this server are: <ul>");
        HttpContext[] contexts = this.getHttpContext().getHttpServer().getContexts();
        int i = 0;
        while (i < contexts.length) {
            HttpContext context = contexts[i];
            writer.write("<li><a href=\"");
            writer.write(context.getContextPath());
            writer.write("/\">");
            writer.write(context.toString());
            writer.write("</a></li>\n");
            ++i;
        }
        writer.write("</ul><small><I>The links above may not work if a virtual host is configured</I></small>");
        i = 0;
        while (i < 10) {
            writer.write("\n<!-- Padding for IE                  -->");
            ++i;
        }
        writer.write("\n</BODY>\n</HTML>\n");
        writer.flush();
        response.setContentLength(writer.size());
        OutputStream out = response.getOutputStream();
        writer.writeTo(out);
        out.close();
    }
}

