/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.webkit.GeolocationPermissions;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import java.util.logging.Level;
import org.openqa.selenium.android.library.AlertManager;
import org.openqa.selenium.android.library.AndroidAlert;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.Logger;
import org.openqa.selenium.android.library.ViewAdapter;
import org.openqa.selenium.android.library.WebDriverViewManager;

public class WebDriverChromeClient {
    private AndroidWebDriver driver;

    public WebDriverChromeClient(AndroidWebDriver driver) {
        this.driver = driver;
    }

    public void onCloseWindow(Object window) {
        AlertManager.removeAlertForView(WebDriverViewManager.getViewAdapterFor(window));
        this.driver.getViewManager().removeView(WebDriverViewManager.getViewAdapterFor(window));
    }

    public void onCreateWindow(ViewAdapter newView) {
        this.driver.getViewManager().addView(newView);
    }

    public void onProgressChanged(Object view, int newProgress) {
        if (newProgress == 100 && this.driver.getLastUrlLoaded() != null && this.driver.getLastUrlLoaded().equals(WebDriverViewManager.getViewAdapterFor(view).getUrl())) {
            this.driver.notifyPageDoneLoading();
        }
    }

    public void onJsAlert(Object view, String message, JsResult result) {
        AlertManager.addAlertForView(WebDriverViewManager.getViewAdapterFor(view), new AndroidAlert(message, result));
    }

    public void onJsConfirm(Object view, String message, JsResult result) {
        AlertManager.addAlertForView(WebDriverViewManager.getViewAdapterFor(view), new AndroidAlert(message, result));
    }

    public void onJsPrompt(Object view, String message, String defaultValue, JsPromptResult result) {
        AlertManager.addAlertForView(WebDriverViewManager.getViewAdapterFor(view), new AndroidAlert(message, (JsResult)result, defaultValue));
    }

    public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
        callback.invoke(origin, true, true);
    }

    public void onJsTimeout() {
        Logger.log(Level.WARNING, WebDriverChromeClient.class.getName(), "onJsTimeout", "WARNING THE JAVASCRIPT EXECUTING TIMED OUT!");
    }
}

