/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.print;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.print.PageMargin;
import org.openqa.selenium.print.PageSize;

public class PrintOptions {
    private Orientation orientation = Orientation.PORTRAIT;
    private double scale = 1.0;
    private boolean background = false;
    private boolean shrinkToFit = true;
    private PageSize pageSize = new PageSize();
    private PageMargin pageMargin = new PageMargin();
    private String[] pageRanges;

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = Require.nonNull("orientation", orientation);
    }

    public String[] getPageRanges() {
        return this.pageRanges;
    }

    public void setPageRanges(String firstRange, String ... ranges) {
        Require.nonNull("pageRanges", firstRange);
        this.pageRanges = new String[ranges.length + 1];
        this.pageRanges[0] = firstRange;
        for (int i = 1; i < ranges.length; ++i) {
            this.pageRanges[i] = ranges[i - 1];
        }
    }

    public void setBackground(boolean background) {
        this.background = Require.nonNull("background", background);
    }

    public boolean getBackground() {
        return this.background;
    }

    public void setScale(double scale) {
        if (scale < 0.1 || scale > 2.0) {
            throw new IllegalArgumentException("Scale value should be between 0.1 and 2");
        }
        this.scale = scale;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean getShrinkToFit() {
        return this.shrinkToFit;
    }

    public void setShrinkToFit(boolean value) {
        this.shrinkToFit = Require.nonNull("value", value);
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = Require.nonNull("pageSize", pageSize);
    }

    public void setPageMargin(PageMargin margin) {
        this.pageMargin = Require.nonNull("margin", margin);
    }

    public PageSize getPageSize() {
        return this.pageSize;
    }

    public PageMargin getPageMargin() {
        return this.pageMargin;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> options = new HashMap<String, Object>(7);
        options.put("page", this.getPageSize());
        options.put("orientation", this.getOrientation().toString());
        options.put("scale", this.getScale());
        options.put("shrinkToFit", this.getShrinkToFit());
        options.put("background", this.getBackground());
        String[] effectivePageRanges = this.getPageRanges();
        if (effectivePageRanges != null) {
            options.put("effectivePageRanges", effectivePageRanges);
        }
        options.put("margin", this.getPageMargin());
        return options;
    }

    public static enum Orientation {
        PORTRAIT("portrait"),
        LANDSCAPE("landscape");

        private final String serialFormat;

        private Orientation(String serialFormat) {
            this.serialFormat = serialFormat;
        }

        public String toString() {
            return this.serialFormat;
        }
    }
}

