/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.virtualauthenticator;

import java.util.Map;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class VirtualAuthenticatorOptions {
    private Protocol protocol = Protocol.CTAP2;
    private Transport transport = Transport.USB;
    private boolean hasResidentKey = false;
    private boolean hasUserVerification = false;
    private boolean isUserConsenting = true;
    private boolean isUserVerified = false;

    public VirtualAuthenticatorOptions setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public VirtualAuthenticatorOptions setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public VirtualAuthenticatorOptions setHasResidentKey(boolean hasResidentKey) {
        this.hasResidentKey = hasResidentKey;
        return this;
    }

    public VirtualAuthenticatorOptions setHasUserVerification(boolean hasUserVerification) {
        this.hasUserVerification = hasUserVerification;
        return this;
    }

    public VirtualAuthenticatorOptions setIsUserConsenting(boolean isUserConsenting) {
        this.isUserConsenting = isUserConsenting;
        return this;
    }

    public VirtualAuthenticatorOptions setIsUserVerified(boolean isUserVerified) {
        this.isUserVerified = isUserVerified;
        return this;
    }

    public Map<String, Object> toMap() {
        return Map.ofEntries(Map.entry("protocol", this.protocol.id), Map.entry("transport", this.transport.id), Map.entry("hasResidentKey", this.hasResidentKey), Map.entry("hasUserVerification", this.hasUserVerification), Map.entry("isUserConsenting", this.isUserConsenting), Map.entry("isUserVerified", this.isUserVerified));
    }

    public static enum Protocol {
        CTAP2("ctap2"),
        U2F("ctap1/u2f");

        public final String id;

        private Protocol(String id) {
            this.id = id;
        }
    }

    public static enum Transport {
        BLE("ble"),
        INTERNAL("internal"),
        NFC("nfc"),
        USB("usb");

        public final String id;

        private Transport(String id) {
            this.id = id;
        }
    }
}

