/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriverException;

public class ReturnedCookie
extends Cookie {
    private final boolean isSecure;
    private String currentHost;

    public ReturnedCookie(String name, String value, String domain, String path, Date expiry, boolean isSecure, String currentUrl) {
        super(name, value, domain, path, expiry);
        this.isSecure = isSecure;
        if (currentUrl != null) {
            try {
                this.currentHost = new URI(currentUrl).getHost();
            }
            catch (URISyntaxException e) {
                throw new WebDriverException("Couldn't convert currentUrl to URI, which should be impossible!", e);
            }
        }
        this.validate();
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    protected void validate() {
        block4: {
            super.validate();
            String domain = this.getDomain();
            if (domain != null && !"".equals(domain)) {
                try {
                    String domainToUse = domain.startsWith("http") ? domain : "http://" + domain;
                    URL url = new URL(domainToUse);
                    InetAddress.getByName(url.getHost());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(String.format("URL not valid: %s", domain));
                }
                catch (UnknownHostException e) {
                    if (this.currentHost != null && this.currentHost.contains(domain)) break block4;
                    throw new IllegalArgumentException(String.format("Domain unknown: %s", domain));
                }
            }
        }
    }

    public String toString() {
        return this.getName() + "=" + this.getValue() + ("".equals(this.getPath()) ? "" : ";path=" + this.getPath()) + (this.getExpiry() == null ? "" : ";expires=" + new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z").format(this.getExpiry())) + (this.isSecure ? ";secure;" : "");
    }
}

