package org.openqa.selenium.devtools.v106.database;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class Database {

    /**
     * Disables database tracking, prevents database events from being sent to the client.
     */
    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Database.disable", params.build());
    }

    /**
     * Enables database tracking, database events will now be delivered to the client.
     */
    public static Command<Void> enable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Database.enable", params.build());
    }

    public static class ExecuteSQLResponse {

        private final java.util.Optional<java.util.List<java.lang.String>> columnNames;

        private final java.util.Optional<java.util.List<java.lang.Object>> values;

        private final java.util.Optional<org.openqa.selenium.devtools.v106.database.model.Error> sqlError;

        public ExecuteSQLResponse(java.util.Optional<java.util.List<java.lang.String>> columnNames, java.util.Optional<java.util.List<java.lang.Object>> values, java.util.Optional<org.openqa.selenium.devtools.v106.database.model.Error> sqlError) {
            this.columnNames = columnNames;
            this.values = values;
            this.sqlError = sqlError;
        }

        public java.util.Optional<java.util.List<java.lang.String>> getColumnNames() {
            return columnNames;
        }

        public java.util.Optional<java.util.List<java.lang.Object>> getValues() {
            return values;
        }

        public java.util.Optional<org.openqa.selenium.devtools.v106.database.model.Error> getSqlError() {
            return sqlError;
        }

        private static ExecuteSQLResponse fromJson(JsonInput input) {
            java.util.Optional<java.util.List<java.lang.String>> columnNames = java.util.Optional.empty();
            java.util.Optional<java.util.List<java.lang.Object>> values = java.util.Optional.empty();
            java.util.Optional<org.openqa.selenium.devtools.v106.database.model.Error> sqlError = java.util.Optional.empty();
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "columnNames":
                        columnNames = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
                        }.getType()));
                        break;
                    case "values":
                        values = java.util.Optional.ofNullable(input.read(new com.google.common.reflect.TypeToken<java.util.List<java.lang.Object>>() {
                        }.getType()));
                        break;
                    case "sqlError":
                        sqlError = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v106.database.model.Error.class));
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new ExecuteSQLResponse(columnNames, values, sqlError);
        }
    }

    public static Command<org.openqa.selenium.devtools.v106.database.Database.ExecuteSQLResponse> executeSQL(org.openqa.selenium.devtools.v106.database.model.DatabaseId databaseId, java.lang.String query) {
        java.util.Objects.requireNonNull(databaseId, "databaseId is required");
        java.util.Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("databaseId", databaseId);
        params.put("query", query);
        return new Command<>("Database.executeSQL", params.build(), input -> input.read(org.openqa.selenium.devtools.v106.database.Database.ExecuteSQLResponse.class));
    }

    public static Command<java.util.List<java.lang.String>> getDatabaseTableNames(org.openqa.selenium.devtools.v106.database.model.DatabaseId databaseId) {
        java.util.Objects.requireNonNull(databaseId, "databaseId is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("databaseId", databaseId);
        return new Command<>("Database.getDatabaseTableNames", params.build(), ConverterFunctions.map("tableNames", new com.google.common.reflect.TypeToken<java.util.List<java.lang.String>>() {
        }.getType()));
    }

    public static Event<org.openqa.selenium.devtools.v106.database.model.Database> addDatabase() {
        return new Event<>("Database.addDatabase", ConverterFunctions.map("database", org.openqa.selenium.devtools.v106.database.model.Database.class));
    }
}
