package org.openqa.selenium.devtools.v106.media.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to kMediaError
 */
public class PlayerError {

    private final java.lang.String errorType;

    private final java.lang.Integer code;

    private final java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerErrorSourceLocation> stack;

    private final java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerError> cause;

    private final java.util.Map<String, Object> data;

    public PlayerError(java.lang.String errorType, java.lang.Integer code, java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerErrorSourceLocation> stack, java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerError> cause, java.util.Map<String, Object> data) {
        this.errorType = java.util.Objects.requireNonNull(errorType, "errorType is required");
        this.code = java.util.Objects.requireNonNull(code, "code is required");
        this.stack = java.util.Objects.requireNonNull(stack, "stack is required");
        this.cause = java.util.Objects.requireNonNull(cause, "cause is required");
        this.data = java.util.Objects.requireNonNull(data, "data is required");
    }

    public java.lang.String getErrorType() {
        return errorType;
    }

    /**
     * Code is the numeric enum entry for a specific set of error codes, such
     * as PipelineStatusCodes in media/base/pipeline_status.h
     */
    public java.lang.Integer getCode() {
        return code;
    }

    /**
     * A trace of where this error was caused / where it passed through.
     */
    public java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerErrorSourceLocation> getStack() {
        return stack;
    }

    /**
     * Errors potentially have a root cause error, ie, a DecoderError might be
     * caused by an WindowsError
     */
    public java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerError> getCause() {
        return cause;
    }

    /**
     * Extra data attached to an error, such as an HRESULT, Video Codec, etc.
     */
    public java.util.Map<String, Object> getData() {
        return data;
    }

    private static PlayerError fromJson(JsonInput input) {
        java.lang.String errorType = null;
        java.lang.Integer code = 0;
        java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerErrorSourceLocation> stack = null;
        java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerError> cause = null;
        java.util.Map<String, Object> data = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "errorType":
                    errorType = input.nextString();
                    break;
                case "code":
                    code = input.nextNumber().intValue();
                    break;
                case "stack":
                    stack = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerErrorSourceLocation>>() {
                    }.getType());
                    break;
                case "cause":
                    cause = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v106.media.model.PlayerError>>() {
                    }.getType());
                    break;
                case "data":
                    data = input.read(new com.google.common.reflect.TypeToken<java.util.Map<String, Object>>() {
                    }.getType());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PlayerError(errorType, code, stack, cause, data);
    }
}
