package org.openqa.selenium.devtools.v111.overlay.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Configurations for Persistent Grid Highlight
 */
public class GridNodeHighlightConfig {

    private final org.openqa.selenium.devtools.v111.overlay.model.GridHighlightConfig gridHighlightConfig;

    private final org.openqa.selenium.devtools.v111.dom.model.NodeId nodeId;

    public GridNodeHighlightConfig(org.openqa.selenium.devtools.v111.overlay.model.GridHighlightConfig gridHighlightConfig, org.openqa.selenium.devtools.v111.dom.model.NodeId nodeId) {
        this.gridHighlightConfig = java.util.Objects.requireNonNull(gridHighlightConfig, "gridHighlightConfig is required");
        this.nodeId = java.util.Objects.requireNonNull(nodeId, "nodeId is required");
    }

    /**
     * A descriptor for the highlight appearance.
     */
    public org.openqa.selenium.devtools.v111.overlay.model.GridHighlightConfig getGridHighlightConfig() {
        return gridHighlightConfig;
    }

    /**
     * Identifier of the node to highlight.
     */
    public org.openqa.selenium.devtools.v111.dom.model.NodeId getNodeId() {
        return nodeId;
    }

    private static GridNodeHighlightConfig fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v111.overlay.model.GridHighlightConfig gridHighlightConfig = null;
        org.openqa.selenium.devtools.v111.dom.model.NodeId nodeId = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "gridHighlightConfig":
                    gridHighlightConfig = input.read(org.openqa.selenium.devtools.v111.overlay.model.GridHighlightConfig.class);
                    break;
                case "nodeId":
                    nodeId = input.read(org.openqa.selenium.devtools.v111.dom.model.NodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new GridNodeHighlightConfig(gridHighlightConfig, nodeId);
    }
}
