/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v112.input.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum MouseButton {
    NONE("none"),
    LEFT("left"),
    MIDDLE("middle"),
    RIGHT("right"),
    BACK("back"),
    FORWARD("forward");

    private String value;

    private MouseButton(String value) {
        this.value = value;
    }

    public static MouseButton fromString(String s) {
        return Arrays.stream(MouseButton.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within MouseButton "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static MouseButton fromJson(JsonInput input) {
        return MouseButton.fromString(input.nextString());
    }
}

