/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v113.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v113.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v113.audits.model.ContentSecurityPolicyViolationType;
import org.openqa.selenium.devtools.v113.audits.model.SourceCodeLocation;
import org.openqa.selenium.devtools.v113.dom.model.BackendNodeId;
import org.openqa.selenium.json.JsonInput;

public class ContentSecurityPolicyIssueDetails {
    private final Optional<String> blockedURL;
    private final String violatedDirective;
    private final Boolean isReportOnly;
    private final ContentSecurityPolicyViolationType contentSecurityPolicyViolationType;
    private final Optional<AffectedFrame> frameAncestor;
    private final Optional<SourceCodeLocation> sourceCodeLocation;
    private final Optional<BackendNodeId> violatingNodeId;

    public ContentSecurityPolicyIssueDetails(Optional<String> blockedURL, String violatedDirective, Boolean isReportOnly, ContentSecurityPolicyViolationType contentSecurityPolicyViolationType, Optional<AffectedFrame> frameAncestor, Optional<SourceCodeLocation> sourceCodeLocation, Optional<BackendNodeId> violatingNodeId) {
        this.blockedURL = blockedURL;
        this.violatedDirective = Objects.requireNonNull(violatedDirective, "violatedDirective is required");
        this.isReportOnly = Objects.requireNonNull(isReportOnly, "isReportOnly is required");
        this.contentSecurityPolicyViolationType = Objects.requireNonNull(contentSecurityPolicyViolationType, "contentSecurityPolicyViolationType is required");
        this.frameAncestor = frameAncestor;
        this.sourceCodeLocation = sourceCodeLocation;
        this.violatingNodeId = violatingNodeId;
    }

    public Optional<String> getBlockedURL() {
        return this.blockedURL;
    }

    public String getViolatedDirective() {
        return this.violatedDirective;
    }

    public Boolean getIsReportOnly() {
        return this.isReportOnly;
    }

    public ContentSecurityPolicyViolationType getContentSecurityPolicyViolationType() {
        return this.contentSecurityPolicyViolationType;
    }

    public Optional<AffectedFrame> getFrameAncestor() {
        return this.frameAncestor;
    }

    public Optional<SourceCodeLocation> getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    private static ContentSecurityPolicyIssueDetails fromJson(JsonInput input) {
        Optional<String> blockedURL = Optional.empty();
        String violatedDirective = null;
        Boolean isReportOnly = false;
        ContentSecurityPolicyViolationType contentSecurityPolicyViolationType = null;
        Optional<AffectedFrame> frameAncestor = Optional.empty();
        Optional<SourceCodeLocation> sourceCodeLocation = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        input.beginObject();
        block18: while (input.hasNext()) {
            switch (input.nextName()) {
                case "blockedURL": {
                    blockedURL = Optional.ofNullable(input.nextString());
                    continue block18;
                }
                case "violatedDirective": {
                    violatedDirective = input.nextString();
                    continue block18;
                }
                case "isReportOnly": {
                    isReportOnly = input.nextBoolean();
                    continue block18;
                }
                case "contentSecurityPolicyViolationType": {
                    contentSecurityPolicyViolationType = (ContentSecurityPolicyViolationType)((Object)input.read(ContentSecurityPolicyViolationType.class));
                    continue block18;
                }
                case "frameAncestor": {
                    frameAncestor = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block18;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = Optional.ofNullable((SourceCodeLocation)input.read(SourceCodeLocation.class));
                    continue block18;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block18;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ContentSecurityPolicyIssueDetails(blockedURL, violatedDirective, isReportOnly, contentSecurityPolicyViolationType, frameAncestor, sourceCodeLocation, violatingNodeId);
    }
}

