package org.openqa.selenium.devtools.v120.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public enum AttributionReportingSourceType {

    NAVIGATION("navigation"), EVENT("event");

    private String value;

    AttributionReportingSourceType(String value) {
        this.value = value;
    }

    public static AttributionReportingSourceType fromString(String s) {
        return java.util.Arrays.stream(AttributionReportingSourceType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within AttributionReportingSourceType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static AttributionReportingSourceType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
