package org.openqa.selenium.devtools.v122.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Request / response headers as keys / values of JSON object.
 */
public class Headers extends java.util.AbstractMap<String, Object> {

    private final java.util.Map<String, Object> headers;

    public Headers(java.util.Map<String, Object> headers) {
        this.headers = java.util.Objects.requireNonNull(headers, "Missing value for Headers");
    }

    public java.util.Set<java.util.Map.Entry<String, Object>> entrySet() {
        return headers.entrySet();
    }

    public Object put(String key, Object value) {
        return headers.put(key, value);
    }

    public boolean containsKey(String key) {
        return headers.containsKey(key);
    }

    public Object get(String key) {
        return headers.get(key);
    }

    protected java.util.Map<String, Object> delegate() {
        return headers;
    }

    private static Headers fromJson(JsonInput input) {
        return new Headers((java.util.Map<String, Object>) input.read(java.util.Map.class));
    }

    public java.util.Map<String, Object> toJson() {
        return headers;
    }

    public String toString() {
        return headers.toString();
    }
}
