package org.openqa.selenium.devtools.v122.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Lists sources for a preloading attempt, specifically the ids of rule sets
 * that had a speculation rule that triggered the attempt, and the
 * BackendNodeIds of <a href> or <area href> elements that triggered the
 * attempt (in the case of attempts triggered by a document rule). It is
 * possible for mulitple rule sets and links to trigger a single attempt.
 */
public class PreloadingAttemptSource {

    private final org.openqa.selenium.devtools.v122.preload.model.PreloadingAttemptKey key;

    private final java.util.List<org.openqa.selenium.devtools.v122.preload.model.RuleSetId> ruleSetIds;

    private final java.util.List<org.openqa.selenium.devtools.v122.dom.model.BackendNodeId> nodeIds;

    public PreloadingAttemptSource(org.openqa.selenium.devtools.v122.preload.model.PreloadingAttemptKey key, java.util.List<org.openqa.selenium.devtools.v122.preload.model.RuleSetId> ruleSetIds, java.util.List<org.openqa.selenium.devtools.v122.dom.model.BackendNodeId> nodeIds) {
        this.key = java.util.Objects.requireNonNull(key, "key is required");
        this.ruleSetIds = java.util.Objects.requireNonNull(ruleSetIds, "ruleSetIds is required");
        this.nodeIds = java.util.Objects.requireNonNull(nodeIds, "nodeIds is required");
    }

    public org.openqa.selenium.devtools.v122.preload.model.PreloadingAttemptKey getKey() {
        return key;
    }

    public java.util.List<org.openqa.selenium.devtools.v122.preload.model.RuleSetId> getRuleSetIds() {
        return ruleSetIds;
    }

    public java.util.List<org.openqa.selenium.devtools.v122.dom.model.BackendNodeId> getNodeIds() {
        return nodeIds;
    }

    private static PreloadingAttemptSource fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v122.preload.model.PreloadingAttemptKey key = null;
        java.util.List<org.openqa.selenium.devtools.v122.preload.model.RuleSetId> ruleSetIds = null;
        java.util.List<org.openqa.selenium.devtools.v122.dom.model.BackendNodeId> nodeIds = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "key":
                    key = input.read(org.openqa.selenium.devtools.v122.preload.model.PreloadingAttemptKey.class);
                    break;
                case "ruleSetIds":
                    ruleSetIds = input.readArray(org.openqa.selenium.devtools.v122.preload.model.RuleSetId.class);
                    break;
                case "nodeIds":
                    nodeIds = input.readArray(org.openqa.selenium.devtools.v122.dom.model.BackendNodeId.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new PreloadingAttemptSource(key, ruleSetIds, nodeIds);
    }
}
