/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v123.page.model;

import java.util.Arrays;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.json.JsonInput;

public enum TransitionType {
    LINK("link"),
    TYPED("typed"),
    ADDRESS_BAR("address_bar"),
    AUTO_BOOKMARK("auto_bookmark"),
    AUTO_SUBFRAME("auto_subframe"),
    MANUAL_SUBFRAME("manual_subframe"),
    GENERATED("generated"),
    AUTO_TOPLEVEL("auto_toplevel"),
    FORM_SUBMIT("form_submit"),
    RELOAD("reload"),
    KEYWORD("keyword"),
    KEYWORD_GENERATED("keyword_generated"),
    OTHER("other");

    private String value;

    private TransitionType(String value) {
        this.value = value;
    }

    public static TransitionType fromString(String s) {
        return Arrays.stream(TransitionType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within TransitionType "));
    }

    public String toString() {
        return this.value;
    }

    public String toJson() {
        return this.value;
    }

    private static TransitionType fromJson(JsonInput input) {
        return TransitionType.fromString(input.nextString());
    }
}

