package org.openqa.selenium.devtools.v124.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public class LowTextContrastIssueDetails {

    private final org.openqa.selenium.devtools.v124.dom.model.BackendNodeId violatingNodeId;

    private final java.lang.String violatingNodeSelector;

    private final java.lang.Number contrastRatio;

    private final java.lang.Number thresholdAA;

    private final java.lang.Number thresholdAAA;

    private final java.lang.String fontSize;

    private final java.lang.String fontWeight;

    public LowTextContrastIssueDetails(org.openqa.selenium.devtools.v124.dom.model.BackendNodeId violatingNodeId, java.lang.String violatingNodeSelector, java.lang.Number contrastRatio, java.lang.Number thresholdAA, java.lang.Number thresholdAAA, java.lang.String fontSize, java.lang.String fontWeight) {
        this.violatingNodeId = java.util.Objects.requireNonNull(violatingNodeId, "violatingNodeId is required");
        this.violatingNodeSelector = java.util.Objects.requireNonNull(violatingNodeSelector, "violatingNodeSelector is required");
        this.contrastRatio = java.util.Objects.requireNonNull(contrastRatio, "contrastRatio is required");
        this.thresholdAA = java.util.Objects.requireNonNull(thresholdAA, "thresholdAA is required");
        this.thresholdAAA = java.util.Objects.requireNonNull(thresholdAAA, "thresholdAAA is required");
        this.fontSize = java.util.Objects.requireNonNull(fontSize, "fontSize is required");
        this.fontWeight = java.util.Objects.requireNonNull(fontWeight, "fontWeight is required");
    }

    public org.openqa.selenium.devtools.v124.dom.model.BackendNodeId getViolatingNodeId() {
        return violatingNodeId;
    }

    public java.lang.String getViolatingNodeSelector() {
        return violatingNodeSelector;
    }

    public java.lang.Number getContrastRatio() {
        return contrastRatio;
    }

    public java.lang.Number getThresholdAA() {
        return thresholdAA;
    }

    public java.lang.Number getThresholdAAA() {
        return thresholdAAA;
    }

    public java.lang.String getFontSize() {
        return fontSize;
    }

    public java.lang.String getFontWeight() {
        return fontWeight;
    }

    private static LowTextContrastIssueDetails fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v124.dom.model.BackendNodeId violatingNodeId = null;
        java.lang.String violatingNodeSelector = null;
        java.lang.Number contrastRatio = 0;
        java.lang.Number thresholdAA = 0;
        java.lang.Number thresholdAAA = 0;
        java.lang.String fontSize = null;
        java.lang.String fontWeight = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "violatingNodeId":
                    violatingNodeId = input.read(org.openqa.selenium.devtools.v124.dom.model.BackendNodeId.class);
                    break;
                case "violatingNodeSelector":
                    violatingNodeSelector = input.nextString();
                    break;
                case "contrastRatio":
                    contrastRatio = input.nextNumber();
                    break;
                case "thresholdAA":
                    thresholdAA = input.nextNumber();
                    break;
                case "thresholdAAA":
                    thresholdAAA = input.nextNumber();
                    break;
                case "fontSize":
                    fontSize = input.nextString();
                    break;
                case "fontWeight":
                    fontWeight = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new LowTextContrastIssueDetails(violatingNodeId, violatingNodeSelector, contrastRatio, thresholdAA, thresholdAAA, fontSize, fontWeight);
    }
}
