package org.openqa.selenium.devtools.v124.fedcm.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The buttons on the FedCM dialog.
 */
public enum DialogButton {

    CONFIRMIDPLOGINCONTINUE("ConfirmIdpLoginContinue"), ERRORGOTIT("ErrorGotIt"), ERRORMOREDETAILS("ErrorMoreDetails");

    private String value;

    DialogButton(String value) {
        this.value = value;
    }

    public static DialogButton fromString(String s) {
        return java.util.Arrays.stream(DialogButton.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within DialogButton "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static DialogButton fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
