package org.openqa.selenium.devtools.v126.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The reason why request was blocked.
 */
public enum CorsError {

    DISALLOWEDBYMODE("DisallowedByMode"),
    INVALIDRESPONSE("InvalidResponse"),
    WILDCARDORIGINNOTALLOWED("WildcardOriginNotAllowed"),
    MISSINGALLOWORIGINHEADER("MissingAllowOriginHeader"),
    MULTIPLEALLOWORIGINVALUES("MultipleAllowOriginValues"),
    INVALIDALLOWORIGINVALUE("InvalidAllowOriginValue"),
    ALLOWORIGINMISMATCH("AllowOriginMismatch"),
    INVALIDALLOWCREDENTIALS("InvalidAllowCredentials"),
    CORSDISABLEDSCHEME("CorsDisabledScheme"),
    PREFLIGHTINVALIDSTATUS("PreflightInvalidStatus"),
    PREFLIGHTDISALLOWEDREDIRECT("PreflightDisallowedRedirect"),
    PREFLIGHTWILDCARDORIGINNOTALLOWED("PreflightWildcardOriginNotAllowed"),
    PREFLIGHTMISSINGALLOWORIGINHEADER("PreflightMissingAllowOriginHeader"),
    PREFLIGHTMULTIPLEALLOWORIGINVALUES("PreflightMultipleAllowOriginValues"),
    PREFLIGHTINVALIDALLOWORIGINVALUE("PreflightInvalidAllowOriginValue"),
    PREFLIGHTALLOWORIGINMISMATCH("PreflightAllowOriginMismatch"),
    PREFLIGHTINVALIDALLOWCREDENTIALS("PreflightInvalidAllowCredentials"),
    PREFLIGHTMISSINGALLOWEXTERNAL("PreflightMissingAllowExternal"),
    PREFLIGHTINVALIDALLOWEXTERNAL("PreflightInvalidAllowExternal"),
    PREFLIGHTMISSINGALLOWPRIVATENETWORK("PreflightMissingAllowPrivateNetwork"),
    PREFLIGHTINVALIDALLOWPRIVATENETWORK("PreflightInvalidAllowPrivateNetwork"),
    INVALIDALLOWMETHODSPREFLIGHTRESPONSE("InvalidAllowMethodsPreflightResponse"),
    INVALIDALLOWHEADERSPREFLIGHTRESPONSE("InvalidAllowHeadersPreflightResponse"),
    METHODDISALLOWEDBYPREFLIGHTRESPONSE("MethodDisallowedByPreflightResponse"),
    HEADERDISALLOWEDBYPREFLIGHTRESPONSE("HeaderDisallowedByPreflightResponse"),
    REDIRECTCONTAINSCREDENTIALS("RedirectContainsCredentials"),
    INSECUREPRIVATENETWORK("InsecurePrivateNetwork"),
    INVALIDPRIVATENETWORKACCESS("InvalidPrivateNetworkAccess"),
    UNEXPECTEDPRIVATENETWORKACCESS("UnexpectedPrivateNetworkAccess"),
    NOCORSREDIRECTMODENOTFOLLOW("NoCorsRedirectModeNotFollow"),
    PREFLIGHTMISSINGPRIVATENETWORKACCESSID("PreflightMissingPrivateNetworkAccessId"),
    PREFLIGHTMISSINGPRIVATENETWORKACCESSNAME("PreflightMissingPrivateNetworkAccessName"),
    PRIVATENETWORKACCESSPERMISSIONUNAVAILABLE("PrivateNetworkAccessPermissionUnavailable"),
    PRIVATENETWORKACCESSPERMISSIONDENIED("PrivateNetworkAccessPermissionDenied");

    private String value;

    CorsError(String value) {
        this.value = value;
    }

    public static CorsError fromString(String s) {
        return java.util.Arrays.stream(CorsError.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within CorsError "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static CorsError fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
