package org.openqa.selenium.devtools.v129.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class SensorReadingSingle {

    private final java.lang.Number value;

    public SensorReadingSingle(java.lang.Number value) {
        this.value = java.util.Objects.requireNonNull(value, "value is required");
    }

    public java.lang.Number getValue() {
        return value;
    }

    private static SensorReadingSingle fromJson(JsonInput input) {
        java.lang.Number value = 0;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "value":
                    value = input.nextNumber();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new SensorReadingSingle(value);
    }
}
