package org.openqa.selenium.devtools.v129.audits.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum MixedContentResolutionStatus {

    MIXEDCONTENTBLOCKED("MixedContentBlocked"), MIXEDCONTENTAUTOMATICALLYUPGRADED("MixedContentAutomaticallyUpgraded"), MIXEDCONTENTWARNING("MixedContentWarning");

    private String value;

    MixedContentResolutionStatus(String value) {
        this.value = value;
    }

    public static MixedContentResolutionStatus fromString(String s) {
        return java.util.Arrays.stream(MixedContentResolutionStatus.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within MixedContentResolutionStatus "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static MixedContentResolutionStatus fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
