package org.openqa.selenium.devtools.v130.deviceorientation;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

@Beta()
public class DeviceOrientation {

    /**
     * Clears the overridden Device Orientation.
     */
    public static Command<Void> clearDeviceOrientationOverride() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        return new Command<>("DeviceOrientation.clearDeviceOrientationOverride", Map.copyOf(params));
    }

    /**
     * Overrides the Device Orientation.
     */
    public static Command<Void> setDeviceOrientationOverride(java.lang.Number alpha, java.lang.Number beta, java.lang.Number gamma) {
        java.util.Objects.requireNonNull(alpha, "alpha is required");
        java.util.Objects.requireNonNull(beta, "beta is required");
        java.util.Objects.requireNonNull(gamma, "gamma is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("alpha", alpha);
        params.put("beta", beta);
        params.put("gamma", gamma);
        return new Command<>("DeviceOrientation.setDeviceOrientationOverride", Map.copyOf(params));
    }
}
