package org.openqa.selenium.devtools.v130.domdebugger;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * DOM debugging allows setting breakpoints on particular DOM operations and events. JavaScript
 * execution will stop on these operations as if there was a regular breakpoint set.
 */
public class DOMDebugger {

    /**
     * Returns event listeners of the given object.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v130.domdebugger.model.EventListener>> getEventListeners(org.openqa.selenium.devtools.v130.runtime.model.RemoteObjectId objectId, java.util.Optional<java.lang.Integer> depth, java.util.Optional<java.lang.Boolean> pierce) {
        java.util.Objects.requireNonNull(objectId, "objectId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("objectId", objectId);
        depth.ifPresent(p -> params.put("depth", p));
        pierce.ifPresent(p -> params.put("pierce", p));
        return new Command<>("DOMDebugger.getEventListeners", Map.copyOf(params), ConverterFunctions.map("listeners", input -> input.readArray(org.openqa.selenium.devtools.v130.domdebugger.model.EventListener.class)));
    }

    /**
     * Removes DOM breakpoint that was set using `setDOMBreakpoint`.
     */
    public static Command<Void> removeDOMBreakpoint(org.openqa.selenium.devtools.v130.dom.model.NodeId nodeId, org.openqa.selenium.devtools.v130.domdebugger.model.DOMBreakpointType type) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        java.util.Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        params.put("type", type);
        return new Command<>("DOMDebugger.removeDOMBreakpoint", Map.copyOf(params));
    }

    /**
     * Removes breakpoint on particular DOM event.
     */
    public static Command<Void> removeEventListenerBreakpoint(java.lang.String eventName, java.util.Optional<java.lang.String> targetName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        targetName.ifPresent(p -> params.put("targetName", p));
        return new Command<>("DOMDebugger.removeEventListenerBreakpoint", Map.copyOf(params));
    }

    /**
     * Removes breakpoint on particular native event.
     */
    @Beta()
    @Deprecated()
    public static Command<Void> removeInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        return new Command<>("DOMDebugger.removeInstrumentationBreakpoint", Map.copyOf(params));
    }

    /**
     * Removes breakpoint from XMLHttpRequest.
     */
    public static Command<Void> removeXHRBreakpoint(java.lang.String url) {
        java.util.Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("url", url);
        return new Command<>("DOMDebugger.removeXHRBreakpoint", Map.copyOf(params));
    }

    /**
     * Sets breakpoint on particular CSP violations.
     */
    @Beta()
    public static Command<Void> setBreakOnCSPViolation(java.util.List<org.openqa.selenium.devtools.v130.domdebugger.model.CSPViolationType> violationTypes) {
        java.util.Objects.requireNonNull(violationTypes, "violationTypes is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("violationTypes", violationTypes);
        return new Command<>("DOMDebugger.setBreakOnCSPViolation", Map.copyOf(params));
    }

    /**
     * Sets breakpoint on particular operation with DOM.
     */
    public static Command<Void> setDOMBreakpoint(org.openqa.selenium.devtools.v130.dom.model.NodeId nodeId, org.openqa.selenium.devtools.v130.domdebugger.model.DOMBreakpointType type) {
        java.util.Objects.requireNonNull(nodeId, "nodeId is required");
        java.util.Objects.requireNonNull(type, "type is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("nodeId", nodeId);
        params.put("type", type);
        return new Command<>("DOMDebugger.setDOMBreakpoint", Map.copyOf(params));
    }

    /**
     * Sets breakpoint on particular DOM event.
     */
    public static Command<Void> setEventListenerBreakpoint(java.lang.String eventName, java.util.Optional<java.lang.String> targetName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        targetName.ifPresent(p -> params.put("targetName", p));
        return new Command<>("DOMDebugger.setEventListenerBreakpoint", Map.copyOf(params));
    }

    /**
     * Sets breakpoint on particular native event.
     */
    @Beta()
    @Deprecated()
    public static Command<Void> setInstrumentationBreakpoint(java.lang.String eventName) {
        java.util.Objects.requireNonNull(eventName, "eventName is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("eventName", eventName);
        return new Command<>("DOMDebugger.setInstrumentationBreakpoint", Map.copyOf(params));
    }

    /**
     * Sets breakpoint on XMLHttpRequest.
     */
    public static Command<Void> setXHRBreakpoint(java.lang.String url) {
        java.util.Objects.requireNonNull(url, "url is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("url", url);
        return new Command<>("DOMDebugger.setXHRBreakpoint", Map.copyOf(params));
    }
}
