package org.openqa.selenium.devtools.v130.emulation.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
 * Missing optional values will be filled in by the target with what it would normally use.
 */
@org.openqa.selenium.Beta()
public class UserAgentMetadata {

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> brands;

    private final java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> fullVersionList;

    private final java.util.Optional<java.lang.String> fullVersion;

    private final java.lang.String platform;

    private final java.lang.String platformVersion;

    private final java.lang.String architecture;

    private final java.lang.String model;

    private final java.lang.Boolean mobile;

    private final java.util.Optional<java.lang.String> bitness;

    private final java.util.Optional<java.lang.Boolean> wow64;

    public UserAgentMetadata(java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> brands, java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> fullVersionList, java.util.Optional<java.lang.String> fullVersion, java.lang.String platform, java.lang.String platformVersion, java.lang.String architecture, java.lang.String model, java.lang.Boolean mobile, java.util.Optional<java.lang.String> bitness, java.util.Optional<java.lang.Boolean> wow64) {
        this.brands = brands;
        this.fullVersionList = fullVersionList;
        this.fullVersion = fullVersion;
        this.platform = java.util.Objects.requireNonNull(platform, "platform is required");
        this.platformVersion = java.util.Objects.requireNonNull(platformVersion, "platformVersion is required");
        this.architecture = java.util.Objects.requireNonNull(architecture, "architecture is required");
        this.model = java.util.Objects.requireNonNull(model, "model is required");
        this.mobile = java.util.Objects.requireNonNull(mobile, "mobile is required");
        this.bitness = bitness;
        this.wow64 = wow64;
    }

    /**
     * Brands appearing in Sec-CH-UA.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> getBrands() {
        return brands;
    }

    /**
     * Brands appearing in Sec-CH-UA-Full-Version-List.
     */
    public java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> getFullVersionList() {
        return fullVersionList;
    }

    @Deprecated()
    public java.util.Optional<java.lang.String> getFullVersion() {
        return fullVersion;
    }

    public java.lang.String getPlatform() {
        return platform;
    }

    public java.lang.String getPlatformVersion() {
        return platformVersion;
    }

    public java.lang.String getArchitecture() {
        return architecture;
    }

    public java.lang.String getModel() {
        return model;
    }

    public java.lang.Boolean getMobile() {
        return mobile;
    }

    public java.util.Optional<java.lang.String> getBitness() {
        return bitness;
    }

    public java.util.Optional<java.lang.Boolean> getWow64() {
        return wow64;
    }

    private static UserAgentMetadata fromJson(JsonInput input) {
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> brands = java.util.Optional.empty();
        java.util.Optional<java.util.List<org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion>> fullVersionList = java.util.Optional.empty();
        java.util.Optional<java.lang.String> fullVersion = java.util.Optional.empty();
        java.lang.String platform = null;
        java.lang.String platformVersion = null;
        java.lang.String architecture = null;
        java.lang.String model = null;
        java.lang.Boolean mobile = false;
        java.util.Optional<java.lang.String> bitness = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> wow64 = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "brands":
                    brands = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion.class));
                    break;
                case "fullVersionList":
                    fullVersionList = java.util.Optional.ofNullable(input.readArray(org.openqa.selenium.devtools.v130.emulation.model.UserAgentBrandVersion.class));
                    break;
                case "fullVersion":
                    fullVersion = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "platform":
                    platform = input.nextString();
                    break;
                case "platformVersion":
                    platformVersion = input.nextString();
                    break;
                case "architecture":
                    architecture = input.nextString();
                    break;
                case "model":
                    model = input.nextString();
                    break;
                case "mobile":
                    mobile = input.nextBoolean();
                    break;
                case "bitness":
                    bitness = java.util.Optional.ofNullable(input.nextString());
                    break;
                case "wow64":
                    wow64 = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new UserAgentMetadata(brands, fullVersionList, fullVersion, platform, platformVersion, architecture, model, mobile, bitness, wow64);
    }
}
