package org.openqa.selenium.devtools.v132.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * An object representing a report generated by the Reporting API.
 */
@org.openqa.selenium.Beta()
public class ReportingApiReport {

    private final org.openqa.selenium.devtools.v132.network.model.ReportId id;

    private final java.lang.String initiatorUrl;

    private final java.lang.String destination;

    private final java.lang.String type;

    private final org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch timestamp;

    private final java.lang.Integer depth;

    private final java.lang.Integer completedAttempts;

    private final java.util.Map<String, Object> body;

    private final org.openqa.selenium.devtools.v132.network.model.ReportStatus status;

    public ReportingApiReport(org.openqa.selenium.devtools.v132.network.model.ReportId id, java.lang.String initiatorUrl, java.lang.String destination, java.lang.String type, org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch timestamp, java.lang.Integer depth, java.lang.Integer completedAttempts, java.util.Map<String, Object> body, org.openqa.selenium.devtools.v132.network.model.ReportStatus status) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.initiatorUrl = java.util.Objects.requireNonNull(initiatorUrl, "initiatorUrl is required");
        this.destination = java.util.Objects.requireNonNull(destination, "destination is required");
        this.type = java.util.Objects.requireNonNull(type, "type is required");
        this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        this.depth = java.util.Objects.requireNonNull(depth, "depth is required");
        this.completedAttempts = java.util.Objects.requireNonNull(completedAttempts, "completedAttempts is required");
        this.body = java.util.Objects.requireNonNull(body, "body is required");
        this.status = java.util.Objects.requireNonNull(status, "status is required");
    }

    public org.openqa.selenium.devtools.v132.network.model.ReportId getId() {
        return id;
    }

    /**
     * The URL of the document that triggered the report.
     */
    public java.lang.String getInitiatorUrl() {
        return initiatorUrl;
    }

    /**
     * The name of the endpoint group that should be used to deliver the report.
     */
    public java.lang.String getDestination() {
        return destination;
    }

    /**
     * The type of the report (specifies the set of data that is contained in the report body).
     */
    public java.lang.String getType() {
        return type;
    }

    /**
     * When the report was generated.
     */
    public org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch getTimestamp() {
        return timestamp;
    }

    /**
     * How many uploads deep the related request was.
     */
    public java.lang.Integer getDepth() {
        return depth;
    }

    /**
     * The number of delivery attempts made so far, not including an active attempt.
     */
    public java.lang.Integer getCompletedAttempts() {
        return completedAttempts;
    }

    public java.util.Map<String, Object> getBody() {
        return body;
    }

    public org.openqa.selenium.devtools.v132.network.model.ReportStatus getStatus() {
        return status;
    }

    private static ReportingApiReport fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v132.network.model.ReportId id = null;
        java.lang.String initiatorUrl = null;
        java.lang.String destination = null;
        java.lang.String type = null;
        org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch timestamp = null;
        java.lang.Integer depth = 0;
        java.lang.Integer completedAttempts = 0;
        java.util.Map<String, Object> body = null;
        org.openqa.selenium.devtools.v132.network.model.ReportStatus status = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v132.network.model.ReportId.class);
                    break;
                case "initiatorUrl":
                    initiatorUrl = input.nextString();
                    break;
                case "destination":
                    destination = input.nextString();
                    break;
                case "type":
                    type = input.nextString();
                    break;
                case "timestamp":
                    timestamp = input.read(org.openqa.selenium.devtools.v132.network.model.TimeSinceEpoch.class);
                    break;
                case "depth":
                    depth = input.nextNumber().intValue();
                    break;
                case "completedAttempts":
                    completedAttempts = input.nextNumber().intValue();
                    break;
                case "body":
                    body = (java.util.Map<String, Object>) input.read(java.util.Map.class);
                    break;
                case "status":
                    status = input.read(org.openqa.selenium.devtools.v132.network.model.ReportStatus.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ReportingApiReport(id, initiatorUrl, destination, type, timestamp, depth, completedAttempts, body, status);
    }
}
