/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v132.preload.model;

import java.util.Objects;
import org.openqa.selenium.devtools.v132.network.model.RequestId;
import org.openqa.selenium.devtools.v132.page.model.FrameId;
import org.openqa.selenium.devtools.v132.preload.model.PrefetchStatus;
import org.openqa.selenium.devtools.v132.preload.model.PreloadingAttemptKey;
import org.openqa.selenium.devtools.v132.preload.model.PreloadingStatus;
import org.openqa.selenium.json.JsonInput;

public class PrefetchStatusUpdated {
    private final PreloadingAttemptKey key;
    private final FrameId initiatingFrameId;
    private final String prefetchUrl;
    private final PreloadingStatus status;
    private final PrefetchStatus prefetchStatus;
    private final RequestId requestId;

    public PrefetchStatusUpdated(PreloadingAttemptKey key, FrameId initiatingFrameId, String prefetchUrl, PreloadingStatus status, PrefetchStatus prefetchStatus, RequestId requestId) {
        this.key = Objects.requireNonNull(key, "key is required");
        this.initiatingFrameId = Objects.requireNonNull(initiatingFrameId, "initiatingFrameId is required");
        this.prefetchUrl = Objects.requireNonNull(prefetchUrl, "prefetchUrl is required");
        this.status = Objects.requireNonNull(status, "status is required");
        this.prefetchStatus = Objects.requireNonNull(prefetchStatus, "prefetchStatus is required");
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
    }

    public PreloadingAttemptKey getKey() {
        return this.key;
    }

    public FrameId getInitiatingFrameId() {
        return this.initiatingFrameId;
    }

    public String getPrefetchUrl() {
        return this.prefetchUrl;
    }

    public PreloadingStatus getStatus() {
        return this.status;
    }

    public PrefetchStatus getPrefetchStatus() {
        return this.prefetchStatus;
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    private static PrefetchStatusUpdated fromJson(JsonInput input) {
        PreloadingAttemptKey key = null;
        FrameId initiatingFrameId = null;
        String prefetchUrl = null;
        PreloadingStatus status = null;
        PrefetchStatus prefetchStatus = null;
        RequestId requestId = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "key": {
                    key = (PreloadingAttemptKey)input.read(PreloadingAttemptKey.class);
                    continue block16;
                }
                case "initiatingFrameId": {
                    initiatingFrameId = (FrameId)input.read(FrameId.class);
                    continue block16;
                }
                case "prefetchUrl": {
                    prefetchUrl = input.nextString();
                    continue block16;
                }
                case "status": {
                    status = (PreloadingStatus)((Object)input.read(PreloadingStatus.class));
                    continue block16;
                }
                case "prefetchStatus": {
                    prefetchStatus = (PrefetchStatus)((Object)input.read(PrefetchStatus.class));
                    continue block16;
                }
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new PrefetchStatusUpdated(key, initiatingFrameId, prefetchUrl, status, prefetchStatus, requestId);
    }
}

