/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.css.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v136.css.model.CSSStyle;
import org.openqa.selenium.devtools.v136.css.model.StyleSheetId;
import org.openqa.selenium.devtools.v136.css.model.StyleSheetOrigin;
import org.openqa.selenium.devtools.v136.css.model.Value;
import org.openqa.selenium.json.JsonInput;

public class CSSPositionTryRule {
    private final Value name;
    private final Optional<StyleSheetId> styleSheetId;
    private final StyleSheetOrigin origin;
    private final CSSStyle style;
    private final Boolean active;

    public CSSPositionTryRule(Value name, Optional<StyleSheetId> styleSheetId, StyleSheetOrigin origin, CSSStyle style, Boolean active) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.styleSheetId = styleSheetId;
        this.origin = Objects.requireNonNull(origin, "origin is required");
        this.style = Objects.requireNonNull(style, "style is required");
        this.active = Objects.requireNonNull(active, "active is required");
    }

    public Value getName() {
        return this.name;
    }

    public Optional<StyleSheetId> getStyleSheetId() {
        return this.styleSheetId;
    }

    public StyleSheetOrigin getOrigin() {
        return this.origin;
    }

    public CSSStyle getStyle() {
        return this.style;
    }

    public Boolean getActive() {
        return this.active;
    }

    private static CSSPositionTryRule fromJson(JsonInput input) {
        Value name = null;
        Optional<StyleSheetId> styleSheetId = Optional.empty();
        StyleSheetOrigin origin = null;
        CSSStyle style = null;
        Boolean active = false;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = (Value)input.read(Value.class);
                    continue block14;
                }
                case "styleSheetId": {
                    styleSheetId = Optional.ofNullable((StyleSheetId)input.read(StyleSheetId.class));
                    continue block14;
                }
                case "origin": {
                    origin = (StyleSheetOrigin)((Object)input.read(StyleSheetOrigin.class));
                    continue block14;
                }
                case "style": {
                    style = (CSSStyle)input.read(CSSStyle.class);
                    continue block14;
                }
                case "active": {
                    active = input.nextBoolean();
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CSSPositionTryRule(name, styleSheetId, origin, style, active);
    }
}

