/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v136.performance;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v136.performance.model.Metric;
import org.openqa.selenium.devtools.v136.performance.model.Metrics;
import org.openqa.selenium.json.JsonInput;

public class Performance {
    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Performance.disable", Map.copyOf(params));
    }

    public static Command<Void> enable(Optional<EnableTimeDomain> timeDomain) {
        LinkedHashMap params = new LinkedHashMap();
        timeDomain.ifPresent(p -> params.put("timeDomain", p));
        return new Command("Performance.enable", Map.copyOf(params));
    }

    @Beta
    @Deprecated
    public static Command<Void> setTimeDomain(SetTimeDomainTimeDomain timeDomain) {
        Objects.requireNonNull(timeDomain, "timeDomain is required");
        LinkedHashMap<String, SetTimeDomainTimeDomain> params = new LinkedHashMap<String, SetTimeDomainTimeDomain>();
        params.put("timeDomain", timeDomain);
        return new Command("Performance.setTimeDomain", Map.copyOf(params));
    }

    public static Command<List<Metric>> getMetrics() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Performance.getMetrics", Map.copyOf(params), ConverterFunctions.map((String)"metrics", input -> input.readArray(Metric.class)));
    }

    public static Event<Metrics> metrics() {
        return new Event("Performance.metrics", input -> (Metrics)input.read(Metrics.class));
    }

    public static enum SetTimeDomainTimeDomain {
        TIMETICKS("timeTicks"),
        THREADTICKS("threadTicks");

        private String value;

        private SetTimeDomainTimeDomain(String value) {
            this.value = value;
        }

        public static SetTimeDomainTimeDomain fromString(String s) {
            return Arrays.stream(SetTimeDomainTimeDomain.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within SetTimeDomainTimeDomain "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static SetTimeDomainTimeDomain fromJson(JsonInput input) {
            return SetTimeDomainTimeDomain.fromString(input.nextString());
        }
    }

    public static enum EnableTimeDomain {
        TIMETICKS("timeTicks"),
        THREADTICKS("threadTicks");

        private String value;

        private EnableTimeDomain(String value) {
            this.value = value;
        }

        public static EnableTimeDomain fromString(String s) {
            return Arrays.stream(EnableTimeDomain.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new DevToolsException("Given value " + s + " is not found within EnableTimeDomain "));
        }

        public String toString() {
            return this.value;
        }

        public String toJson() {
            return this.value;
        }

        private static EnableTimeDomain fromJson(JsonInput input) {
            return EnableTimeDomain.fromString(input.nextString());
        }
    }
}

