package org.openqa.selenium.devtools.v141.network.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@org.openqa.selenium.Beta()
public class ContentSecurityPolicyStatus {

    private final java.lang.String effectiveDirectives;

    private final java.lang.Boolean isEnforced;

    private final org.openqa.selenium.devtools.v141.network.model.ContentSecurityPolicySource source;

    public ContentSecurityPolicyStatus(java.lang.String effectiveDirectives, java.lang.Boolean isEnforced, org.openqa.selenium.devtools.v141.network.model.ContentSecurityPolicySource source) {
        this.effectiveDirectives = java.util.Objects.requireNonNull(effectiveDirectives, "effectiveDirectives is required");
        this.isEnforced = java.util.Objects.requireNonNull(isEnforced, "isEnforced is required");
        this.source = java.util.Objects.requireNonNull(source, "source is required");
    }

    public java.lang.String getEffectiveDirectives() {
        return effectiveDirectives;
    }

    public java.lang.Boolean getIsEnforced() {
        return isEnforced;
    }

    public org.openqa.selenium.devtools.v141.network.model.ContentSecurityPolicySource getSource() {
        return source;
    }

    private static ContentSecurityPolicyStatus fromJson(JsonInput input) {
        java.lang.String effectiveDirectives = null;
        java.lang.Boolean isEnforced = false;
        org.openqa.selenium.devtools.v141.network.model.ContentSecurityPolicySource source = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "effectiveDirectives":
                    effectiveDirectives = input.nextString();
                    break;
                case "isEnforced":
                    isEnforced = input.nextBoolean();
                    break;
                case "source":
                    source = input.read(org.openqa.selenium.devtools.v141.network.model.ContentSecurityPolicySource.class);
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new ContentSecurityPolicyStatus(effectiveDirectives, isEnforced, source);
    }
}
