/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v142.network.model.ConnectionType;
import org.openqa.selenium.json.JsonInput;

@Beta
public class NetworkConditions {
    private final String urlPattern;
    private final Number latency;
    private final Number downloadThroughput;
    private final Number uploadThroughput;
    private final Optional<ConnectionType> connectionType;
    private final Optional<Number> packetLoss;
    private final Optional<Integer> packetQueueLength;
    private final Optional<Boolean> packetReordering;

    public NetworkConditions(String urlPattern, Number latency, Number downloadThroughput, Number uploadThroughput, Optional<ConnectionType> connectionType, Optional<Number> packetLoss, Optional<Integer> packetQueueLength, Optional<Boolean> packetReordering) {
        this.urlPattern = Objects.requireNonNull(urlPattern, "urlPattern is required");
        this.latency = Objects.requireNonNull(latency, "latency is required");
        this.downloadThroughput = Objects.requireNonNull(downloadThroughput, "downloadThroughput is required");
        this.uploadThroughput = Objects.requireNonNull(uploadThroughput, "uploadThroughput is required");
        this.connectionType = connectionType;
        this.packetLoss = packetLoss;
        this.packetQueueLength = packetQueueLength;
        this.packetReordering = packetReordering;
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public Number getLatency() {
        return this.latency;
    }

    public Number getDownloadThroughput() {
        return this.downloadThroughput;
    }

    public Number getUploadThroughput() {
        return this.uploadThroughput;
    }

    public Optional<ConnectionType> getConnectionType() {
        return this.connectionType;
    }

    public Optional<Number> getPacketLoss() {
        return this.packetLoss;
    }

    public Optional<Integer> getPacketQueueLength() {
        return this.packetQueueLength;
    }

    public Optional<Boolean> getPacketReordering() {
        return this.packetReordering;
    }

    private static NetworkConditions fromJson(JsonInput input) {
        String urlPattern = null;
        Number latency = 0;
        Number downloadThroughput = 0;
        Number uploadThroughput = 0;
        Optional<ConnectionType> connectionType = Optional.empty();
        Optional<Number> packetLoss = Optional.empty();
        Optional<Integer> packetQueueLength = Optional.empty();
        Optional<Boolean> packetReordering = Optional.empty();
        input.beginObject();
        block20: while (input.hasNext()) {
            switch (input.nextName()) {
                case "urlPattern": {
                    urlPattern = input.nextString();
                    continue block20;
                }
                case "latency": {
                    latency = input.nextNumber();
                    continue block20;
                }
                case "downloadThroughput": {
                    downloadThroughput = input.nextNumber();
                    continue block20;
                }
                case "uploadThroughput": {
                    uploadThroughput = input.nextNumber();
                    continue block20;
                }
                case "connectionType": {
                    connectionType = Optional.ofNullable((ConnectionType)((Object)input.read(ConnectionType.class)));
                    continue block20;
                }
                case "packetLoss": {
                    packetLoss = Optional.ofNullable(input.nextNumber());
                    continue block20;
                }
                case "packetQueueLength": {
                    packetQueueLength = Optional.ofNullable(input.nextNumber().intValue());
                    continue block20;
                }
                case "packetReordering": {
                    packetReordering = Optional.ofNullable(input.nextBoolean());
                    continue block20;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new NetworkConditions(urlPattern, latency, downloadThroughput, uploadThroughput, connectionType, packetLoss, packetQueueLength, packetReordering);
    }
}

