/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v143.autofill;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v143.autofill.model.Address;
import org.openqa.selenium.devtools.v143.autofill.model.AddressFormFilled;
import org.openqa.selenium.devtools.v143.autofill.model.CreditCard;
import org.openqa.selenium.devtools.v143.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v143.page.model.FrameId;

@Beta
public class Autofill {
    public static Command<Void> trigger(BackendNodeId fieldId, Optional<FrameId> frameId, Optional<CreditCard> card, Optional<Address> address) {
        Objects.requireNonNull(fieldId, "fieldId is required");
        LinkedHashMap<String, BackendNodeId> params = new LinkedHashMap<String, BackendNodeId>();
        params.put("fieldId", fieldId);
        frameId.ifPresent(p -> params.put("frameId", (BackendNodeId)p));
        card.ifPresent(p -> params.put("card", (BackendNodeId)p));
        address.ifPresent(p -> params.put("address", (BackendNodeId)p));
        return new Command("Autofill.trigger", Map.copyOf(params));
    }

    public static Command<Void> setAddresses(List<Address> addresses) {
        Objects.requireNonNull(addresses, "addresses is required");
        LinkedHashMap<String, List<Address>> params = new LinkedHashMap<String, List<Address>>();
        params.put("addresses", addresses);
        return new Command("Autofill.setAddresses", Map.copyOf(params));
    }

    public static Command<Void> disable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Autofill.disable", Map.copyOf(params));
    }

    public static Command<Void> enable() {
        LinkedHashMap params = new LinkedHashMap();
        return new Command("Autofill.enable", Map.copyOf(params));
    }

    public static Event<AddressFormFilled> addressFormFilled() {
        return new Event("Autofill.addressFormFilled", input -> (AddressFormFilled)input.read(AddressFormFilled.class));
    }
}

