/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.InputStream;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class DumpHttpExchangeFilter
implements Filter {
    public static final Logger LOG = Logger.getLogger(DumpHttpExchangeFilter.class.getName());
    private final Level logLevel;

    public DumpHttpExchangeFilter() {
        this(Level.FINER);
    }

    public DumpHttpExchangeFilter(Level logLevel) {
        this.logLevel = (Level)Require.nonNull((String)"Log level", (Object)logLevel);
    }

    @Override
    public HttpHandler apply(HttpHandler next) {
        return req -> {
            LOG.log(this.logLevel, () -> this.requestLogMessage(req));
            HttpResponse res = next.execute(req);
            LOG.log(this.logLevel, () -> this.responseLogMessage(res));
            return res;
        };
    }

    private void expandHeadersAndContent(StringBuilder builder, HttpMessage<?> message) {
        message.forEachHeader((name, value) -> builder.append("  ").append((String)name).append(": ").append((String)value).append("\n"));
        builder.append("\n");
        builder.append(Contents.string(message));
    }

    String requestLogMessage(HttpRequest req) {
        Supplier<InputStream> memoized = Contents.memoize(req.getContent());
        req.setContent((Supplier)memoized);
        StringBuilder reqInfo = new StringBuilder();
        reqInfo.append("HTTP Request: ").append(req).append("\n");
        this.expandHeadersAndContent(reqInfo, req);
        return reqInfo.toString();
    }

    String responseLogMessage(HttpResponse res) {
        Supplier<InputStream> resContents = Contents.memoize(res.getContent());
        res.setContent((Supplier)resContents);
        StringBuilder resInfo = new StringBuilder("HTTP Response: ");
        resInfo.append("Status code: ").append(res.getStatus()).append("\n");
        this.expandHeadersAndContent(resInfo, res);
        return resInfo.toString();
    }
}

