/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.UrlTemplate;

public abstract class Route
implements HttpHandler,
Routable {
    public HttpHandler fallbackTo(Supplier<HttpHandler> handler) {
        Require.nonNull((String)"Handler", handler);
        return req -> {
            if (this.matches(req)) {
                return this.execute(req);
            }
            return ((HttpHandler)Require.state((String)"Handler", (Object)((HttpHandler)handler.get())).nonNull()).execute(req);
        };
    }

    @Override
    public final HttpResponse execute(HttpRequest req) {
        if (!this.matches(req)) {
            return (HttpResponse)new HttpResponse().setStatus(404).setContent(Contents.asJson(Map.of("value", Map.of("error", "unknown command", "message", "Unable to find handler for " + String.valueOf(req), "stacktrace", ""))));
        }
        HttpResponse res = this.handle(req);
        if (res != null) {
            return res;
        }
        return (HttpResponse)((HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).addHeader("WebDriver-Error", "unsupported operation")).addHeader("Selenium-Route", "NULL_RES")).setContent(Contents.asJson(Map.of("value", Map.of("error", "unsupported operation", "message", String.format("Found handler for %s, but nothing was returned", req), "stacktrace", ""))));
    }

    protected abstract HttpResponse handle(HttpRequest var1);

    public static PredicatedConfig matching(Predicate<HttpRequest> predicate) {
        return new PredicatedConfig((Predicate)Require.nonNull((String)"Predicate", predicate));
    }

    public static TemplatizedRouteConfig delete(String template) {
        UrlTemplate urlTemplate = new UrlTemplate((String)Require.nonNull((String)"URL template", (Object)template));
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.DELETE).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig get(String template) {
        UrlTemplate urlTemplate = new UrlTemplate((String)Require.nonNull((String)"URL template", (Object)template));
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.GET).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig post(String template) {
        UrlTemplate urlTemplate = new UrlTemplate((String)Require.nonNull((String)"URL template", (Object)template));
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.POST).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static TemplatizedRouteConfig options(String template) {
        UrlTemplate urlTemplate = new UrlTemplate((String)Require.nonNull((String)"URL template", (Object)template));
        return new TemplatizedRouteConfig(new MatchesHttpMethod(HttpMethod.OPTIONS).and(new MatchesTemplate(urlTemplate)), urlTemplate);
    }

    public static NestedRouteConfig prefix(String prefix) {
        Require.nonNull((String)"Prefix", (Object)prefix);
        Require.stateCondition((!prefix.isEmpty() ? 1 : 0) != 0, (String)"Prefix to use must not be of 0 length", (Object[])new Object[0]);
        return new NestedRouteConfig(prefix);
    }

    public static Route combine(Routable first, Routable ... others) {
        Require.nonNull((String)"At least one route", (Object)first);
        return new CombinedRoute(Stream.concat(Stream.of(first), Stream.of(others)));
    }

    public static Route combine(Iterable<Routable> routes) {
        Require.nonNull((String)"At least one route", routes);
        return new CombinedRoute(StreamSupport.stream(routes.spliterator(), false));
    }

    public static class PredicatedConfig {
        private final Predicate<HttpRequest> predicate;

        private PredicatedConfig(Predicate<HttpRequest> predicate) {
            this.predicate = (Predicate)Require.nonNull((String)"Predicate", predicate);
        }

        public Route to(Supplier<HttpHandler> handler) {
            return new PredicatedRoute(this.predicate, (Supplier)Require.nonNull((String)"Handler supplier", handler));
        }
    }

    public static class TemplatizedRouteConfig {
        private final Predicate<HttpRequest> predicate;
        private final UrlTemplate template;

        private TemplatizedRouteConfig(Predicate<HttpRequest> predicate, UrlTemplate template) {
            this.predicate = (Predicate)Require.nonNull((String)"Predicate", predicate);
            this.template = (UrlTemplate)Require.nonNull((String)"URL template", (Object)template);
        }

        public Route to(Supplier<HttpHandler> handler) {
            Require.nonNull((String)"Handler supplier", handler);
            return this.to((Map<String, String> params) -> (HttpHandler)handler.get());
        }

        public Route to(Function<Map<String, String>, HttpHandler> handlerFunc) {
            Require.nonNull((String)"Handler creator", handlerFunc);
            return new TemplatizedRoute(this.template, this.predicate, handlerFunc);
        }
    }

    private static class MatchesHttpMethod
    implements Predicate<HttpRequest> {
        private final HttpMethod method;

        private MatchesHttpMethod(HttpMethod method) {
            this.method = (HttpMethod)((Object)Require.nonNull((String)"HTTP method to test", (Object)((Object)method)));
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.method == request.getMethod();
        }
    }

    private static class MatchesTemplate
    implements Predicate<HttpRequest> {
        private final UrlTemplate template;

        private MatchesTemplate(UrlTemplate template) {
            this.template = (UrlTemplate)Require.nonNull((String)"URL template to test", (Object)template);
        }

        @Override
        public boolean test(HttpRequest request) {
            return this.template.match(request.getUri()) != null;
        }
    }

    public static class NestedRouteConfig {
        private final String prefix;

        private NestedRouteConfig(String prefix) {
            this.prefix = (String)Require.nonNull((String)"Prefix", (Object)prefix);
        }

        public Route to(Route route) {
            Require.nonNull((String)"Target for requests", (Object)route);
            return new NestedRoute(this.prefix, route);
        }
    }

    private static class CombinedRoute
    extends Route {
        private final List<Routable> allRoutes;

        private CombinedRoute(Stream<Routable> routes) {
            List routables = routes.collect(Collectors.toList());
            Collections.reverse(routables);
            this.allRoutes = List.copyOf(routables);
            Require.stateCondition((!this.allRoutes.isEmpty() ? 1 : 0) != 0, (String)"At least one route must be specified.", (Object[])new Object[0]);
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.allRoutes.stream().anyMatch(route -> route.matches(request));
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            return this.allRoutes.stream().filter(route -> route.matches(req)).findFirst().map(route -> route).orElse(request -> (HttpResponse)new HttpResponse().setStatus(404).setContent(Contents.utf8String("No handler found for " + String.valueOf(request)))).execute(req);
        }
    }

    private static class PredicatedRoute
    extends Route {
        private final Predicate<HttpRequest> predicate;
        private final Supplier<HttpHandler> supplier;

        private PredicatedRoute(Predicate<HttpRequest> predicate, Supplier<HttpHandler> supplier) {
            this.predicate = (Predicate)Require.nonNull((String)"Predicate", predicate);
            this.supplier = (Supplier)Require.nonNull((String)"Supplier", supplier);
        }

        @Override
        public boolean matches(HttpRequest httpRequest) {
            return this.predicate.test(httpRequest);
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            HttpHandler handler = this.supplier.get();
            if (handler == null) {
                throw new IllegalStateException("No handler available.");
            }
            return handler.execute(req);
        }
    }

    private static class NestedRoute
    extends Route {
        private final String[] prefixPaths;
        private final String prefix;
        private final Route route;

        private NestedRoute(String prefix, Route route) {
            this.prefixPaths = ((String)Require.nonNull((String)"Prefix", (Object)prefix)).split("/");
            this.prefix = prefix;
            this.route = (Route)Require.nonNull((String)"Target for requests", (Object)route);
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.hasPrefix(request) && this.route.matches(this.transform(request));
        }

        private boolean hasPrefix(HttpRequest request) {
            String[] parts = request.getUri().split("/");
            if (parts.length < this.prefixPaths.length) {
                return false;
            }
            for (int i = 0; i < this.prefixPaths.length; ++i) {
                if (this.prefixPaths[i].equals(parts[i])) continue;
                return false;
            }
            return true;
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            return this.route.execute(this.transform(req));
        }

        private HttpRequest transform(HttpRequest request) {
            String unprefixed = this.hasPrefix(request) ? request.getUri().substring(this.prefix.length()) : request.getUri();
            HttpRequest toForward = new HttpRequest(request.getMethod(), unprefixed);
            request.forEachHeader((name, value) -> {
                if (name == null) {
                    return;
                }
                toForward.addHeader((String)name, (String)value);
            });
            request.getAttributeNames().forEach(attr -> toForward.setAttribute((String)attr, request.getAttribute((String)attr)));
            LinkedList rawPrefixes = request.getAttribute("selenium.route");
            if (!(rawPrefixes instanceof List)) {
                rawPrefixes = new LinkedList();
            }
            List prefixes = Stream.concat(((List)rawPrefixes).stream(), Stream.of(this.prefix)).map(String::valueOf).collect(Collectors.toUnmodifiableList());
            toForward.setAttribute("selenium.route", prefixes);
            request.getQueryParameterNames().forEach(name -> request.getQueryParameters((String)name).forEach(value -> toForward.addQueryParameter((String)name, (String)value)));
            toForward.setContent(request.getContent());
            return toForward;
        }
    }

    private static class TemplatizedRoute
    extends Route {
        private final UrlTemplate template;
        private final Predicate<HttpRequest> predicate;
        private final Function<Map<String, String>, HttpHandler> handlerFunction;

        private TemplatizedRoute(UrlTemplate template, Predicate<HttpRequest> predicate, Function<Map<String, String>, HttpHandler> handlerFunction) {
            this.template = (UrlTemplate)Require.nonNull((String)"URL template", (Object)template);
            this.predicate = (Predicate)Require.nonNull((String)"Predicate", predicate);
            this.handlerFunction = (Function)Require.nonNull((String)"Handler function", handlerFunction);
        }

        @Override
        public boolean matches(HttpRequest request) {
            return this.predicate.test(request);
        }

        @Override
        protected HttpResponse handle(HttpRequest req) {
            UrlTemplate.Match match = this.template.match(req.getUri());
            HttpHandler handler = this.handlerFunction.apply(match == null ? Map.of() : match.getParameters());
            if (handler == null) {
                return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.utf8String("Unable to find handler for " + String.valueOf(req)));
            }
            return handler.execute(req);
        }
    }
}

